package com.polycom.sampleapps.servlet.apps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;

/**
 *
 * <p>Title: PersonalizeApplicationsServlet</p>
 *
 * <p>Description: Persists personalized applications information for users.</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class PersonalizeApplicationsServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Handles POST request submitted from configureapplications.jsp
	 * and processes applications that were selected by the user and persit against user.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			String errorMessage =
				"Please login to personalize applications.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "/login.jsp";
		}
		else
		{
			// GET ALL ENABLED APPLICATION IDS FROM REQUEST.
			boolean validRefreshPeriod = true;
			String errorMessage = "";
			List<String> appList = new ArrayList<String> ();
			Map<String, String> appMap = new HashMap<String, String> ();
			Enumeration paramEnum = a_request.getParameterNames();
			while (paramEnum.hasMoreElements())
			{
				String paramName = (String) paramEnum.nextElement();
				if (paramName.startsWith("appenable"))
				{
					String appId = paramName.substring(9);
					appList.add(appId);
				}
				else if (paramName.startsWith("apprefresh"))
				{
					String appId = paramName.substring(10);
					String refreshValue = a_request.getParameter(paramName);
					try
					{
						int temp = Integer.parseInt(refreshValue);
						if (temp <= 0)
						{
							errorMessage =
								"Enter valid refresh periods.";
							validRefreshPeriod = false;
							//break;
						}
						else
						{
							appMap.put(appId, refreshValue);
						}
					}
					catch (NumberFormatException ex)
					{
						errorMessage = "Enter valid refresh periods.";
						validRefreshPeriod = false;
						//break;
					}
				}
			}
			// UPDATE APPLICATIONLIST.
			user.enableApplications(appList);
			// UPDATE APPLICATION REFRESH PERIODS
			user.updateRefreshPeriod(appMap);
			// PERSISTING ENABLED APPLICATIONS
			String userFilePath = appContext.getXmlDirPath() + user.getName() +
				".xml";
			try
			{
				PersistUser.persist(user, userFilePath);
			}
			catch (IOException ex)
			{
			}
			// DISPLAY ALL ENABLED APPLICATIONS.
			a_request.setAttribute("username", user.getName());
			a_request.setAttribute("appidmap", appMap);
			if (!validRefreshPeriod)
			{
				a_request.setAttribute("errormessage", errorMessage);
				jspPage = "/configureapplications.jsp";
				a_request.setAttribute("applicationlist", user.getApplications());
			}
			else
			{
				a_request.setAttribute("applicationlist",
									   user.getEnabledApplications());
				jspPage = "/applications.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Handles GET request.
	 * Displays configured aplications to the user.
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			String errorMessage =
				"Please login to personalize applications.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "/login.jsp";
		}
		else
		{
			a_request.setAttribute("username", user.getName());
			a_request.setAttribute("applicationlist",
								   user.getEnabledApplications());
			jspPage = "/applications.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
