package com.polycom.sampleapps.servlet.apps;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: ViewApplicationsServlet</p>
 *
 * <p>Description: Displays the user enabled/configured applications.</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class ViewApplicationsServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Handles GET request.
	 * Displays all available applications for the user.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void service(HttpServletRequest a_request,
						HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			String errorMessage =
				"Please login to view available applications.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "/login.jsp";
		}
		// IF USERNAME IS NOT NULL THEN DISPLAY USER ENABLED CHANNELS
		else
		{
			if (a_request.getParameter("confapps") != null)
			{
				a_request.setAttribute("applicationlist", user.getApplications());
				jspPage = "/configureapplications.jsp";
			}
			else
			{
				//System.out.println("Aapplications List : " + user.getApplications());
				a_request.setAttribute("applicationlist",
									   user.getEnabledApplications());
				jspPage = "/applications.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
