package com.polycom.sampleapps.servlet.common;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Executors;

/**
 *
 * <p>Title: BlockedThreadInterruptor</p>
 *
 * <p>Description: Interrupts the threads created for reading content of items configured for applications</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class BlockedThreadInterruptor
{
	private final int MINIMUM_THREAD_COUNT = 1;
	private static BlockedThreadInterruptor m_self;
	private ScheduledExecutorService m_execuotorService;
	private ScheduledFuture m_future;
	ApplicationContext m_appContext;

	private BlockedThreadInterruptor(ApplicationContext a_appContext)
	{
		m_appContext = a_appContext;
		m_execuotorService = Executors.newScheduledThreadPool(
			MINIMUM_THREAD_COUNT);
		m_future = m_execuotorService.scheduleWithFixedDelay(
			new ScheduledInterrupter(), Constants.DEFAULT_THREAD_DELAY_PERIOD,
			Constants.DEFAULT_THREAD_DELAY_PERIOD, TimeUnit.MILLISECONDS);
	}

	public static BlockedThreadInterruptor getInstance(ApplicationContext a_appContext)
	{
		if (m_self == null)
		{
			m_self = new BlockedThreadInterruptor(a_appContext);
		}
		return m_self;
	}

	public void shutdown()
	{
		m_execuotorService.shutdown();
	}

	/**
	 * Interrupts threads of stock, weather, news and thought managers
	 */
	private void interrupt()
	{
		m_appContext.getStockManager().deleteItems();
		m_appContext.getWeatherManager().deleteItems();
		//m_appContext.getNewsManager().deleteItems();
		//RefreshManager manager = m_appContext.getStockRefreshManager();
		//manager.interruptBlockedThreads();
		//manager = m_appContext.getWeatherRefreshManager();
		//manager.interruptBlockedThreads();
		//manager = m_appContext.getNewsRefreshManager();
		//manager.interruptBlockedThreads();
		//manager = m_appContext.getThoughtRefreshManager();
		//manager.interruptBlockedThreads();
	}

	class ScheduledInterrupter implements Runnable
	{
		public void run()
		{
			interrupt();
		}
	}
}
