package com.polycom.sampleapps.servlet.common;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.URL;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.protocol.BufferingHttpClientHandler;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;

import com.polycom.sampleapps.servlet.stocks.SymbolKey;

public class CheckURL extends Thread {

	private BasicHttpParams params;

	private BasicHttpProcessor httpproc;

	private String m_url;

	private Object result;

	private boolean m_isByteData;

	public CheckURL(String urlAddress, boolean isByteData) {
		m_url = urlAddress;
		m_isByteData = isByteData;
	}

	public void run() {
		final HttpParams params = new BasicHttpParams(null);
		params
				.setIntParameter(HttpConnectionParams.SO_TIMEOUT, 50000)
				.setIntParameter(HttpConnectionParams.CONNECTION_TIMEOUT, 70000)
				.setIntParameter(HttpConnectionParams.SOCKET_BUFFER_SIZE,
						8 * 1024).setBooleanParameter(
						HttpConnectionParams.STALE_CONNECTION_CHECK, false)
				.setBooleanParameter(HttpConnectionParams.TCP_NODELAY, true)
				.setParameter(HttpProtocolParams.USER_AGENT,
						"Jakarta-HttpComponents-NIO/1.1");

		try {
			final ConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(
					2, params);
			BasicHttpProcessor httpproc = new BasicHttpProcessor();
			httpproc.addInterceptor(new RequestContent());
			httpproc.addInterceptor(new RequestTargetHost());
			httpproc.addInterceptor(new RequestConnControl());
			httpproc.addInterceptor(new RequestUserAgent());
			httpproc.addInterceptor(new RequestExpectContinue());

			BufferingHttpClientHandler handler = new BufferingHttpClientHandler(
					httpproc, new MyNewsHttpRequestExecutionHandler(),
					new DefaultConnectionReuseStrategy(), params);

			// handler.setEventListener(new EventLogger());

			final IOEventDispatch ioEventDispatch = new DefaultClientIOEventDispatch(
					handler, params);

			Thread t = new Thread(new Runnable() {
				public void run() {
					try {
						ioReactor.execute(ioEventDispatch);
					} catch (InterruptedIOException ex) {
						System.err.println("Interrupted");
					} catch (IOException e) {
						System.err.println("I/O error: " + e.getMessage());
					}
				}
			});
			t.start();

			SessionRequest[] reqs = new SessionRequest[1];
			URL url = new URL(m_url);
			String hostAddress = url.getHost();
			String uri = url.getFile();			
			SymbolKey quoteKey = new SymbolKey(uri, new HttpHost(hostAddress));
			reqs[0] = ioReactor.connect(new InetSocketAddress(hostAddress, 80),
					null, quoteKey, null);

			this.sleep(1000 * 10);
			if (ioReactor != null) {
				ioReactor.shutdown();
			}
		} catch (Exception e) {
		}

	}

	class MyNewsHttpRequestExecutionHandler implements
			HttpRequestExecutionHandler {

		public void initalizeContext(final HttpContext context,
				final Object attachment) {
			// HttpHost targetHost = (HttpHost) attachment;
			SymbolKey chartKey = (SymbolKey) attachment;
			context.setAttribute("URI", chartKey.getURI());
			context.setAttribute(HttpExecutionContext.HTTP_TARGET_HOST,
					chartKey.getHttpHost()); // targetHost);
		}

		public HttpRequest submitRequest(final HttpContext context) {

			HttpHost targetHost = (HttpHost) context
					.getAttribute(HttpExecutionContext.HTTP_TARGET_HOST);
			String uri = (String) context.getAttribute("URI");
			BasicHttpRequest req = new BasicHttpRequest("GET", uri);
			return req;
		}

		public void handleResponse(final HttpResponse response,
				final HttpContext context) {
			HttpEntity entity = response.getEntity();
			String url = "";
			HttpHost host = (HttpHost) context.getAttribute("http.target_host");
			url += host.getSchemeName() + "//" + host.getHostName();
			String uri = (String) context.getAttribute("URI");
			url += uri;
			if (!uri.equals("")) {
				try {
					if (m_isByteData)
						result = EntityUtils.toByteArray(entity);
					else
						result = EntityUtils.toString(entity);
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

	}

	public Object getResult() {
		return result;
	}

	public static void main(String[] args) {

		String url = "http://rss.news.yahoo.com/rss/topstories";
		CheckURL nn = new CheckURL(url, false);
		Thread check = new Thread(nn);
		check.run();		
		nn=null;

	}

}
