package com.polycom.sampleapps.servlet.common;

import java.io.File;

/**
 *
 * <p>Title: Constants</p>
 *
 * <p>Description: Contains constants for tags and attributes inside xml files.
 * Constants for XML files. Constants for idle browser cookies.</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class Constants
{
	public static int DEFAULT_STOCK_THREAD_TIMEOUT = 2 * 60 * 1000;
	public static int DEFAULT_STOCK_CONTENT_READ_TIMEOUT = 1 * 1000;

	public static int DEFAULT_WEATHER_THREAD_TIMEOUT = 21 * 60 * 1000;
	public static int DEFAULT_WEATHER_CONTENT_READ_TIMEOUT = 20 * 60 * 1000;

	public static int DEFAULT_NEWS_THREAD_TIMEOUT = 16 * 60 * 1000;
	public static int DEFAULT_NEWS_CONTENT_READ_TIMEOUT = 15 * 60 * 1000;

	public static int DEFAULT_THOUGHT_THREAD_TIMEOUT = (24 * 60 * 60 * 1000) +
		(60 * 1000);
	public static int DEFAULT_THOUGHT_CONTENT_READ_TIMEOUT = 24 * 60 * 60 * 100;

	public static int CONTENT_READ_RFRESH_RATE = 5 * 1000;
	public static final long UNREGISTER_ITEM_FROM_CACHE_TIME = 5 * 60 * 1000; // 5 minutes

	public static int DEFAULT_CONTENT_READ_TIMEOUT = 20 * 1000;

	public static int DEFAULT_THREAD_DELAY_PERIOD = 15* 60 * 1000;
	
	public static int DEFAULT_IMAGES_CLEANUP_PERIOD = 20* 60 * 1000;

	public static String APPLICATIONS_NOT_AVAILABLE_REFRESH_PERIOD = "5";

	public static int NUMBER_OF_RETRIES = 4;
	
	public static int NEWS_REFRESH_RATE=15*60*1000;
	
	public static int STOCKS_REFRESH_RATE=15*60*1000;
	
	public static int WEATHER_REFRESH_RATE=15*60*1000;
	
	public static int TFTD_REFRESH_RATE=24*60*60*1000;

	// COOKIE NAME
	public static final String COOKIE_USERNAME = "username";

	// CONTENT_TYPE
	public static final String CONTENT_TYPE = "application/xhtml+xml";

	// USER TYPES
	public static final String IT_USER_TYPE = "ITUSER";
	public static final String END_USER_TYPE = "ENDUSER";

	// XML FILES
	public static final String APPLICATIONS_XML_FILE = "default.xml"; // Used by ADMINS
	public static final String USERS_XML_FILE = "users.xml"; // Contains Users and their password and type.

	// TAGS
	public static final String APP_TAG = "application";
	public static final String THOUGHT_TAG = "thought";
	public static final String USER_TAG = "user";
	public static final String USERS_TAG = "users";
	public static final String ITEM_TAG = "item";
	public static final String USER_PROFILE_TAG = "user-profile";

	// ATTRIBUTES
	public static final String ID_ATTR = "id";
	public static final String NAME_ATTR = "name";
	public static final String PASSWORD_ATTR = "password";
	public static final String TYPE_ATTR = "type";
	public static final String MAXALLOWED_ATTR = "maxallowed";
	public static final String HOMEPAGE_ATTR = "homepageenabled";
	public static final String URL_ATTR = "contentproviderurl";
	public static final String DISPLAYURL_ATTR = "displayurl";
	public static final String ENABLED_ATTR = "enabled";
	public static final String REFRESH_PERIOD_ATTR = "refreshperiod";

	// VALUE
	public static final String TRUE_ATTR_VALUE = "true";

	// APPLICATION AND CONTENT IDS FOR IDLE COOKIE
	public static final String APPLICATION_COOKIE_IDLE = "APPLICATION";
	public static final String APP_CONTENT_COOKIE_IDLE = "CONTENT";
	public static final String NEWS_DISPLAYED_INDEX = "NEWS_DISPLAYED_INDEX";
	public static final String NEWS_DISPLAYED_STRING = "NEWS_DISPLAYED_STRING";

	//
	public static final String IMAGES_DIR = "images";
	public static final String STOCKS_BMP_PATH = IMAGES_DIR + File.separator +
		"stocks";
	public static final String WEATHER_BMP_PATH = IMAGES_DIR + File.separator +
		"locations";
}
