package com.polycom.sampleapps.servlet.common;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;

/**
 *
 * <p>Title: ContentReader</p>
 *
 * <p>Description: Connects to the given url and retrieves the content</p>
 *
 * <p>Copyright: Copyright (c) 2006</p>
 *
 * <p>Company: Choral Technologies</p>
 *
 * @author Venu
 * @version 1.0
 */
public class ContentReader
{
	/**
	 * Connects to the specified cntent provider URL and retrieves the content in string format
	 * @param a_contentUrl String
	 * @return String
	 * @throws Exception
	 */
	public static String getContent(String a_contentUrl) throws
		Exception
	{
		StringBuffer result = new StringBuffer();
		HttpURLConnection urlConnection = null;
		ReadableByteChannel channel = null;
		Charset charset = Charset.defaultCharset();
		try
		{
			URL url = new URL(a_contentUrl);
			urlConnection = (HttpURLConnection) url.openConnection();
			try
			{
				int temp = Constants.DEFAULT_CONTENT_READ_TIMEOUT;
				urlConnection.setConnectTimeout(temp);
			}
			catch (NumberFormatException ex)
			{
			}
			urlConnection.connect();
			channel = Channels.newChannel(urlConnection.getInputStream());
			ByteBuffer buff = ByteBuffer.allocate(1024);
			buff.clear();
			while (channel.read(buff) != -1)
			{
				buff.flip();
				result.append(charset.decode(buff).array());
				buff.compact();
			}
		}
		catch (Exception ex2)
		{
			if (channel != null)
			{
				channel.close();
				channel = null;
			}
			if (urlConnection != null)
			{
				urlConnection.disconnect();
				urlConnection = null;
			}
			result = null;
			throw ex2;
		}
		finally
		{
			if (channel != null)
			{
				channel.close();
				channel = null;
			}
			if (urlConnection != null)
			{
				urlConnection.disconnect();
				urlConnection = null;
			}
		}
		return result.toString();
	}

	/**
	 * Connects to the specified cntent provider URL and retrieves the content in byte format
	 * @param a_contentUrl String
	 * @return byte[]
	 * @throws Exception
	 */
	public static byte[] getByteContent(String a_contentUrl) throws
		Exception
	{
		byte[] result = null;
		ByteArrayOutputStream bais = null;
		HttpURLConnection urlConnection = null;
		ReadableByteChannel channel = null;
		try
		{
			URL url = new URL(a_contentUrl);
			urlConnection = (HttpURLConnection) url.openConnection();
			try
			{
				int temp = Constants.DEFAULT_CONTENT_READ_TIMEOUT;
				urlConnection.setConnectTimeout(temp);
			}
			catch (NumberFormatException ex)
			{
			}
			urlConnection.connect();
			bais = new ByteArrayOutputStream();
			InputStream is = urlConnection.getInputStream();
			int availBytes = is.available();
			channel = Channels.newChannel(is);
			ByteBuffer buff = ByteBuffer.allocate(availBytes);
			buff.clear();
			while (channel.read(buff) != -1)
			{
				bais.write(buff.array());
				buff.compact();
			}
			result = bais.toByteArray();
		}
		catch (Exception ex2)
		{
			if (bais != null)
			{
				bais.flush();
				bais.close();
				bais = null;
			}
			if (channel != null)
			{
				channel.close();
				channel = null;
			}
			if (urlConnection != null)
			{
				urlConnection.disconnect();
				urlConnection = null;
			}
			result = null;
			throw ex2;
		}
		finally
		{
			if (bais != null)
			{
				bais.flush();
				bais.close();
				bais = null;
			}
			if (channel != null)
			{
				channel.close();
				channel = null;
			}
			if (urlConnection != null)
			{
				urlConnection.disconnect();
				urlConnection = null;
			}
		}
		return result;
	}
}
