package com.polycom.sampleapps.servlet.common;

import java.util.logging.Level;

/**
 *
 * <p>Title: RunnableReader</p>
 *
 * <p>Description: Reads the content for specified item using Reader and updates last updated result time.</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
  *
 * <p>Company: Polycom, Inc</p>
 *
 * @author not attributable
 * @version 1.0
 */
public class RunnableReader extends Thread
{
	private Reader m_reader;
	private String m_itemName;
	private long m_lastUpdatedResult;
	private int m_interruptTime;
	private boolean m_canRead = true;

	public RunnableReader(Reader a_reader, String a_itemName,
						  int a_interruptTime)
	{
		m_reader = a_reader;
		m_itemName = a_itemName;
		m_interruptTime = a_interruptTime;
	}

	public void run()
	{
		try
		{
			if (m_canRead)
			{
				Object result = m_reader.read(m_itemName);
				m_lastUpdatedResult = System.currentTimeMillis();
				/*if (result != null)
				{
					System.out.println(m_itemName + " successfull...........");
				}*/
			}
		}
		catch (Exception ex)
		{
		}
	}

	/**
	 * Releases the thread from blocked state, if the last updated result time is exceeded.
	 * @return boolean
	 */
	public boolean releaseFromBlockedState()
	{
		boolean result = false;
		long currentTime = System.currentTimeMillis();
		long meanTime = currentTime - m_lastUpdatedResult;
		if (meanTime >= m_interruptTime)
		{
			result = true;
			m_canRead = false;
			try
			{
				ApplicationContext.logger.log(Level.SEVERE,
											  "Interupting Blocked Item : " +
											  m_itemName);
				this.interrupt();
			}
			catch (Exception ex)
			{
			}
		}
		return result;
	}

	public String getItemName()
	{
		return m_itemName;
	}
}
