package com.polycom.sampleapps.servlet.common.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import com.polycom.sampleapps.servlet.common.Constants;

/**
 *
 * <p>Title: Application</p>
 *
 * <p>Description: Holds application specific data and configured items.</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author not attributable
 * @version 1.0
 */
public final class Application
{
	public static final String STOCK_APPLICATION_ID = "1";
	public static final String WEATHER_APPLICATION_ID = "2";
	public static final String NEWS_APPLICATION_ID = "3";
	public static final String THOUGHT_APPLICATION_ID = "4";
	public static final String SCREENSAVER_APPLICATION_ID = "5";

	private String m_appId;
	private String m_appName;
	private String m_displayUrl;
	private String m_maxAllowed;
	private boolean m_enabled;
	private String m_refreshPeriod;
	private Item m_lastViewdStock;
	private Item m_lastViewdLocation;

	private Vector<Item> m_apps;

	public Application(String a_appId, String a_appName, String a_displayUrl,
					   String a_maxAllowed, String a_defaultEnabled,
					   String a_refreshPeriod)
	{
		m_appId = a_appId;
		m_appName = a_appName;
		m_displayUrl = a_displayUrl;
		m_maxAllowed = a_maxAllowed;
		m_refreshPeriod = a_refreshPeriod;
		setIsEnabled(a_defaultEnabled);
	}

	public String getApplicationId()
	{
		return m_appId;
	}

	public String getApplicationName()
	{
		return m_appName;
	}

	public String getDisplayUrl()
	{
		return m_displayUrl;
	}

	public String getMaxAllowed()
	{
		return m_maxAllowed;
	}

	public void setIsEnabled(boolean a_enabled)
	{
		m_enabled = a_enabled;
	}

	public String getRefreshPeriod()
	{
		return m_refreshPeriod;
	}

	public void setRefreshPeriod(String a_refreshPeriod)
	{
		m_refreshPeriod = a_refreshPeriod;
	}

	public void setIsEnabled(String a_enabled)
	{
		if (a_enabled.equalsIgnoreCase(Constants.TRUE_ATTR_VALUE))
		{
			m_enabled = true;
		}
	}

	public boolean isEnabled()
	{
		return m_enabled;
	}

	public void setItems(Vector<Item> a_apps)
	{
		m_apps = a_apps;
	}

	/**
	 * Returns all configured items.
	 * @return Vector
	 */
	public Vector<Item> getItems()
	{
		if(m_apps == null)
		{
			//System.out.println("Empty vector.......");
			m_apps = new Vector<Item>();
		}
		return m_apps;
	}

	/**
	 * Returns Home page enabled items.
	 * @return List
	 */
	public List<Item> getHomePageEnabledItems()
	{
		List<Item> result = new ArrayList<Item> ();
		for (Item cApp : getItems())
		{
			if (cApp.isAddedToHomePage())
			{
				result.add(cApp);
			}
		}
		return result;
	}

	/**
	 * Returns next display item
	 * @param a_lastViewedItem String
	 * @return Item
	 */
	public Item getNextItem(String a_lastViewedItem)
	{
		//System.out.println("LastViewedItem : " + a_lastViewedItem);
		Item result = null;
		boolean isAnyItemShowed = false;
		List<Item> items = getHomePageEnabledItems();
		int size = items.size();
		for (int i=0; i<size; i++)
		{
			Item item = items.get(i);
			if (item.getName().equals(a_lastViewedItem))
			{
				isAnyItemShowed = true;
				if ( (i+1) < size )
				{
					result = items.get(i + 1);
				}
				break;
			}
		}
		if ( result == null && !isAnyItemShowed )
		{
			if ( size > 0 )
			{
				result = items.get(0);
			}
		}
		//System.out.println("Next Item : " + result);
		return result;
	}

	public void setLastViewedStock(Item a_stock)
	{
		m_lastViewdStock = a_stock;
	}

	public Item getLastViewedStock()
	{
		return m_lastViewdStock;
	}

	public void setLastViewedLocation(Item a_loc)
	{
		m_lastViewdLocation = a_loc;
	}

	public Item getLastViewedLocation()
	{
		return m_lastViewdLocation;
	}

	/**
	 * Returns XML string in specified format.
	 * @return String
	 */
	public String getXmlString()
	{
		String output = "";
		//<application id="1" name="Stocks" url="http://ichart.yahoo.com/t?s=" displayurl="viewstocks" perpage="" maxallowed="4" enabled="true">
		output += "<application id=\"" + getApplicationId() + "\" name=\"" +
			getApplicationName() + "\" displayurl=\"" +
			getDisplayUrl() + "\" maxallowed=\"" + getMaxAllowed() +
			"\" enabled=\"" + isEnabled() + "\" refreshperiod=\"" +
			getRefreshPeriod() + "\">";
		for (Item cApp : getItems())
		{
			output += cApp.getXmlString();
		}
		output += "</application>";
		return output;
	}

	public String toString()
	{
		String result = getApplicationName() + ":" + isEnabled();
		//result += "\r\n" + m_apps;
		return result;
	}
}
