package com.polycom.sampleapps.servlet.common.data;

import java.util.ArrayList;
import java.util.List;

/**
 *
 * <p>Title: Channel</p>
 *
 * <p>Description: Holds RSS channel information </p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class Channel
{
	private String m_title;
	private String m_description;
	private List<ChannelItem> m_channelItemList;

	/**
	 * Default constructor
	 */
	public Channel()
	{
		m_channelItemList = new ArrayList<ChannelItem>();
	}

	/**
	 * Constructor takes RSS channel element (required) as arguments
	 * @param a_title String
	 * @param a_description String
	 * @param a_channelItemList List
	 */
	public Channel(String a_title, String a_description, List<ChannelItem> a_channelItemList)
	{
		this();
		m_title = a_title;
		m_description = a_description;
		m_channelItemList = a_channelItemList;
	}

	/**
	 * Sets channel title
	 * @param a_title String
	 */
	public void setTitle(String a_title)
	{
		m_title = a_title;
	}

	/**
	 * Returns channel title
	 * @return String
	 */
	public String getTitle()
	{
		return m_title;
	}

	/**
	 * Sets description of channel
	 * @param a_description String
	 */
	public void setDescription(String a_description)
	{
		m_description = a_description;
	}

	/**
	 * Returns the description of channel
	 * @return String
	 */
	public String getDescription()
	{
		return m_description;
	}

	/**
	 * Adds new channel item read from RSS feed
	 * @param a_channelItem ChannelItem
	 */
	public void addChannelItem(ChannelItem a_channelItem)
	{
		m_channelItemList.add(a_channelItem);
	}

	/**
	 * Returns the channels items read from RSS feed
	 * @return List
	 */
	public List<ChannelItem> getChannelItems()
	{
		return m_channelItemList;
	}

	public String toString()
	{
		return getDescription();
	}
}
