package com.polycom.sampleapps.servlet.common.data;

/**
 *
 * <p>Title: ChannelItem</p>
 *
 * <p>Description: Holds channel item information</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ChannelItem
{
	private String m_title;
	private String m_link;
	private String m_description;

	/**
	 * Default constructor
	 */
	public ChannelItem()
	{
	}

	/**
	 * Constructor takes RSS channel item elements (required) as arguments
	 * @param a_title String
	 * @param a_description String
	 * @param a_link String
	 */
	public ChannelItem(String a_title, String a_description, String a_link)
	{
		m_title = a_title;
		m_description = a_description;
		m_link = a_link;
	}

	/**
	 * Sets channel item title
	 * @param a_title String
	 */
	public void setTitle(String a_title)
	{
		m_title = a_title;
	}

	/**
	 * Returns channel item title
	 * @return String
	 */
	public String getTitle()
	{
		return m_title;
	}

	/**
	 * Sets channel item description
	 * @param a_description String
	 */
	public void setDescription(String a_description)
	{
		m_description = a_description;
	}

	/**
	 * Returns channel item description
	 * @return String
	 */
	public String getDescription()
	{
		return m_description;
	}

	/**
	 * Sets channel item link
	 * @param a_link String
	 */
	public void setLink(String a_link)
	{
		m_link = a_link;
	}

	/**
	 * Returns channel item link
	 * @return String
	 */
	public String getLink()
	{
		return m_link;
	}

	public String toString()
	{
		return "Channel Item :::: " + getTitle() + " :::: " + getLink() + " :::: " + getDescription();
	}
}
