package com.polycom.sampleapps.servlet.common.data;

import com.polycom.sampleapps.servlet.common.Constants;

/**
 *
 * <p>Title: Item</p>
 *
 * <p>Description: Holds the application item (Name, Content Provider URL and Enabled for home page) information</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public final class Item
{
	private String m_name; // Application item name
	private String m_contentProviderUrl; // used for News only
	private boolean m_isAddedToHomePage;

	public Item(String a_name, String a_url, String a_homePage)
	{
		m_name = a_name;
		m_contentProviderUrl = a_url;
		setHomePage(a_homePage);
	}

	public String getName()
	{
		return m_name;
	}

	public String getContentProviderUrl()
	{
		return m_contentProviderUrl;
	}

	public boolean setHomePage(String a_homePage)
	{
		boolean result = false;
		if (a_homePage.equalsIgnoreCase(Constants.TRUE_ATTR_VALUE))
		{
			m_isAddedToHomePage = true;
		}
		return result;
	}

	public boolean isAddedToHomePage()
	{
		return m_isAddedToHomePage;
	}

	public void addToHomePage(boolean a_add)
	{
		m_isAddedToHomePage = a_add;
	}

	public boolean equals(Object a_name)
	{
		boolean result = false;
		if (getName().equals(a_name))
		{
			result = true;
		}
		return result;
	}

	/**
	 * Returns XML string in specified format.
	 * @return String
	 */
	public String getXmlString()
	{
		String output = "";
		//<content name="PLCM" url="PLCM" homepage="true"/>
		output += "<item name=\"" + getName() + "\" contentproviderurl=\"" +
			getContentProviderUrl() + "\" homepageenabled=\"" +
			isAddedToHomePage() + "\"/>";
		return output;
	}

	public String toString()
	{
		return "Name : " + getName() + " : " + isAddedToHomePage();
	}
}
