package com.polycom.sampleapps.servlet.common.data;

import com.polycom.sampleapps.servlet.common.Constants;

/**
 *
 * <p>Title: User</p>
 *
 * <p>Description: Contains user specific information (Name, Password, Type and Alias).</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class User
{
	private String m_name;
	private String m_password;
	private String m_type;

	public User(String a_name, String a_password, String a_type)
	{
		m_name = a_name;
		m_password = a_password;
		m_type = a_type;
	}

	public String getName()
	{
		return m_name;
	}

	public String getPassword()
	{
		return m_password;
	}

	public String getType()
	{
		return m_type;
	}

	public void setPassword(String a_password)
	{
		m_password = a_password;
	}

	public boolean isITUser()
	{
		boolean result = false;
		if (getType().equals(Constants.IT_USER_TYPE))
		{
			result = true;
		}
		return result;
	}

	/**
	 * Returns XML string in specified format.
	 * @return String
	 */
	public String getXmlString()
	{
		String output = "";
		//<user name="e" password="p" type="EndUser">
		output += "<user name=\"" + getName() + "\" password=\"" + getPassword() +
			"\" type=\"" + getType() + "\"/>";
		return output;
	}

	public String toString()
	{
		return getName();
	}
}
