package com.polycom.sampleapps.servlet.common.parsers;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import com.polycom.sampleapps.servlet.common.ContentReader;
import com.polycom.sampleapps.servlet.common.data.Channel;
import com.polycom.sampleapps.servlet.common.data.ChannelItem;

/**
 *
 * <p>Title: RssXmlParser</p>
 *
 * <p>Description: Parses RSS news feed XML content received from RSS news content provider</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class RssXmlParser extends DefaultHandler
{
	private final String CHANNEL = "channel";
	private final String IMAGE = "image";
	private final String TITLE = "title";
	private final String DESCRIPTION = "description";
	private final String ITEM = "item";
	private final String LINK = "link";

	private Channel m_channel;
	private ChannelItem m_channelItem;

	private boolean m_isChannelTag;
	private boolean m_isItemTag;
	private boolean m_isTitleTag;
	private boolean m_isDescTag;
	private boolean m_islinkTag;
	private boolean m_isImageTag;

	private String m_title;
	private String m_desc;
	private String m_link;

	/**
	 * Default constructor.
	 */
	public RssXmlParser()
	{
		m_channel = new Channel();
	}

	/**
	 * This method gets invoked while parsing start tags of RSS news feed.
	 * @param uri String
	 * @param localName String
	 * @param qName String
	 * @param attributes Attributes
	 */
	public void startElement(String uri, String localName, String qName,
							 Attributes attributes)
	{
		if (qName.equals(CHANNEL))
		{
			m_isChannelTag = true;
		}
		else if (qName.equals(IMAGE))
		{
			m_isImageTag = true;
		}
		else if (qName.equals(ITEM))
		{
			if ( m_isChannelTag )
			{
				//System.out.println("channel title : " + m_title);
				//System.out.println("channel desc : " + m_desc);
				m_channel.setTitle(m_title);
				m_channel.setDescription(m_desc);
			}
			m_isChannelTag = false;
			m_isItemTag = true;
			m_channelItem = new ChannelItem();
		}
		else if (qName.equals(TITLE) && !m_isImageTag)
		{
			m_title = "";
			m_isTitleTag = true;
		}
		else if (qName.equals(DESCRIPTION))
		{
			m_desc = "";
			m_isDescTag = true;
		}
		else if (qName.equals(LINK) && !m_isImageTag)
		{
			m_link = "";
			m_islinkTag = true;
		}
	}

	/**
	 * Gives the data available in between the tags
	 * @param chars char[]
	 * @param start int
	 * @param length int
	 */
	public void characters(char[] chars, int start, int length)
	{
		if (m_isChannelTag && !m_isImageTag)
		{
			if ( m_isTitleTag )
			{
				String data = new String(chars, start, length);
				//System.out.println("channel Data : " + data);
				m_title += data;
			}
			else if ( m_isDescTag )
			{
				String data = new String(chars, start, length);
				//System.out.println("channel Data : " + data);
				m_desc += data;
			}
		}
		else if (m_isItemTag)
		{
			if ( m_isTitleTag )
			{
				String data = new String(chars, start, length);
				//System.out.println("item Data title : " + data);
				m_title += data;
			}
			else if ( m_isDescTag )
			{
				String data = new String(chars, start, length);
				//System.out.println("item Data desc : " + data);
				m_desc += data;
			}
			else if ( m_islinkTag )
			{
				String data = new String(chars, start, length);
				//System.out.println("item Data link : " + data);
				m_link += data;
			}
		}
	}

	/**
	 * This method gets invoked while parsing end tags of RSS news feed.
	 * @param uri String
	 * @param localName String
	 * @param qName String
	 */
	public void endElement(String uri, String localName, String qName)
	{
		if (qName.equals(ITEM))
		{
			String tempTitle = "";
			/*int count = 0;
			if ( m_title.indexOf("&") != -1 )
			{
				StringTokenizer stk = new StringTokenizer(m_title, "&");
				while (stk.hasMoreTokens())
				{
					String token = stk.nextToken();
					tempTitle += token + "&amp;";
				}
			}
			else*/
			{
				tempTitle = m_title;
			}
			//System.out.println("item title : " + tempTitle);
			m_channelItem.setTitle(tempTitle);
			m_channelItem.setDescription(m_desc);
			//System.out.println("item desc : " + m_desc);
			m_channelItem.setLink(m_link);
			//System.out.println("item link : " + m_link);
			m_channel.addChannelItem(m_channelItem);
			m_isChannelTag = false;
			m_isItemTag = false;
			m_channelItem = null;
		}
		else if (qName.equals(TITLE))
		{
			m_isTitleTag = false;
		}
		else if (qName.equals(DESCRIPTION))
		{
			m_isDescTag = false;
		}
		else if (qName.equals(LINK))
		{
			m_islinkTag = false;
		}
		else if (qName.equals(IMAGE))
		{
			m_isImageTag = false;
		}
	}

	/**
	 * This method parses the given RSS xml
	 * @param a_rssXml String
	 */
	public Channel parseRssXML(String a_rssXml) throws Exception
	{
		//System.out.println("Parsing RSS XML : " + a_rssXml);
		try
		{
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser saxParser = factory.newSAXParser();
			saxParser.parse(new ByteArrayInputStream(a_rssXml.getBytes()), this);
		}
		catch (IOException ex)
		{
			throw ex;
		}
		catch (SAXException ex)
		{
			throw ex;
		}
		catch (ParserConfigurationException ex)
		{
			throw ex;
		}
		catch (FactoryConfigurationError ex)
		{
			throw ex;
		}
		return m_channel;
	}

	public static void main(String args[])
	{
		try
		{
			RssXmlParser parser = new RssXmlParser();
			String rssXml = ContentReader.getContent("http://rss.news.yahoo.com/rss/terrorism");
			parser.parseRssXML(rssXml);
		}
		catch (Exception ex)
		{
		}
	}
}
