package com.polycom.sampleapps.servlet.common.parsers;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: UserXmlParser</p>
 *
 * <p>Description: Parses the <USER>.xml file</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class UserXmlParser extends DefaultHandler
{
	private Vector<Application> m_appsList;
	private Vector<Item> m_itemsList;
	private Application m_application;
	private UserProfile m_user;

	/**
	 * Default constructor.
	 */
	public UserXmlParser()
	{
		m_appsList = new Vector<Application> ();
		m_itemsList = new Vector<Item> ();
	}

	/**
	 * This method gets invoked while parsing the applications.xml file.
	 * @param uri String
	 * @param localName String
	 * @param qName String
	 * @param attributes Attributes
	 */
	public void startElement(String uri, String localName, String qName,
							 Attributes attributes)
	{
		// Looking for <user> tag and retrieveing the defined attributes.
		// Creates a User object and stores it into a users list.
		if (qName.equals(Constants.USER_PROFILE_TAG))
		{
			m_user = new UserProfile();
		}
		else if (qName.equals(Constants.APP_TAG))
		{
			String id = attributes.getValue(Constants.ID_ATTR);
			String name = attributes.getValue(Constants.NAME_ATTR);
			String maxallowed = attributes.getValue(Constants.
				MAXALLOWED_ATTR);
			String displayUrl = attributes.getValue(Constants.DISPLAYURL_ATTR);
			String enabled = attributes.getValue(Constants.ENABLED_ATTR);
			String refreshPeriod = attributes.getValue(Constants.
				REFRESH_PERIOD_ATTR);
			m_application = new Application(id, name, displayUrl, maxallowed,
											enabled, refreshPeriod);
		}
		else if (qName.equals(Constants.ITEM_TAG))
		{
			String name = attributes.getValue(Constants.NAME_ATTR);
			String querystring = attributes.getValue(Constants.URL_ATTR);
			String homepage = attributes.getValue(Constants.HOMEPAGE_ATTR);
			Item cApp = new Item(name, querystring, homepage);
			m_itemsList.add(cApp);
		}
	}

	/**
	 * This method gets invoked while parsing end tags of RSS news feed.
	 * @param uri String
	 * @param localName String
	 * @param qName String
	 */
	public void endElement(String uri, String localName, String qName)
	{
		if (qName.equals(Constants.USER_PROFILE_TAG))
		{
			m_user.setApplications(m_appsList);
		}
		else if (qName.equals(Constants.APP_TAG))
		{
			m_application.setItems(m_itemsList);
			Application tempApp = m_application;
			m_appsList.add(tempApp);
			m_itemsList = new Vector<Item> ();
		}
	}

	/**
	 * This method parses the given users.xml file and returns list of User objects
	 * @param a_file String
	 */
	public UserProfile parseUserXML(String a_file)
	{
		ApplicationContext.logger.log(Level.INFO,
									  "Parsing applications.xml from location : " +
									  a_file);
		try
		{
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser saxParser = factory.newSAXParser();
			saxParser.parse(new File(a_file), this);
		}
		catch (IOException ex)
		{
		}
		catch (SAXException ex)
		{
		}
		catch (ParserConfigurationException ex)
		{
		}
		catch (FactoryConfigurationError ex)
		{
		}
		return m_user;
	}
}
