package com.polycom.sampleapps.servlet.common.parsers;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.User;

/**
 *
 * <p>Title: UsersXmlParser</p>
 *
 * <p>Description: Parses the users defined in users.xml file</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class UsersXmlParser extends DefaultHandler
{
	private Vector<User> m_usersList;

	/**
	 * Default constructor.
	 */
	public UsersXmlParser()
	{
		m_usersList = new Vector<User> ();
	}

	/**
	 * This method gets invoked while parsing the users.xml file.
	 * @param uri String
	 * @param localName String
	 * @param qName String
	 * @param attributes Attributes
	 */
	public void startElement(String uri, String localName, String qName,
							 Attributes attributes)
	{
		// Looking for <user> tag and retrieveing the defined attributes.
		// Creates a User object and stores it into a users list.
		if (qName.equals(Constants.USER_TAG))
		{
			String username = attributes.getValue(Constants.NAME_ATTR);
			String password = attributes.getValue(Constants.PASSWORD_ATTR);
			String type = attributes.getValue(Constants.TYPE_ATTR);
			User user = new User(username, password, type);
			m_usersList.add(user);
		}
	}

	/**
	 * This method parses the given users.xml file and returns list of User objects
	 * @param a_file String
	 */
	public Vector<User> parseUserXML(String a_file)
	{
		ApplicationContext.logger.log(Level.INFO,
									  "Parsing Users xml from location : " +
									  a_file);
		try
		{
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser saxParser = factory.newSAXParser();
			saxParser.parse(new File(a_file), this);
		}
		catch (IOException ex)
		{
		}
		catch (SAXException ex)
		{
		}
		catch (ParserConfigurationException ex)
		{
		}
		catch (FactoryConfigurationError ex)
		{
		}
		return m_usersList;
	}
}
