package com.polycom.sampleapps.servlet.common.persistance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: PersistApplications</p>
 *
 * <p>Description: Persists applications configured by the IT Manager into default.xml file</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class PersistApplications
{
	public static synchronized void persist(UserProfile a_user, String a_filePath) throws
		IOException, FileNotFoundException
	{
		//System.out.println("Persisting Applications into : " + a_filePath);
		String output = a_user.getXmlString();
		FileOutputStream fos = new FileOutputStream(new File(a_filePath));
		fos.write(output.getBytes());
		fos.flush();
		fos.close();
	}
}
