package com.polycom.sampleapps.servlet.common.persistance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: PersistUser</p>
 *
 * <p>Description: Persists user into <USERNAME>.xml file</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class PersistUser
{
	public static synchronized void persist(UserProfile a_user, String a_filePath) throws
		IOException, FileNotFoundException
	{
		//System.out.println("Persisting User into : " + a_filePath);
		String output = a_user.getXmlString();
		FileOutputStream fos = new FileOutputStream(new File(a_filePath));
		fos.write(output.getBytes());
		fos.flush();
		fos.close();
	}
}
