package com.polycom.sampleapps.servlet.common.persistance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

import com.polycom.sampleapps.servlet.common.data.User;

/**
 *
 * <p>Title: PersistUsers</p>
 *
 * <p>Description: Persists users into users.xml file</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class PersistUsers
{
	public static void persist(Vector<User> a_users, String a_filePath) throws
		IOException, FileNotFoundException
	{
		//System.out.println("Persisting Users into : " + a_filePath);
		String output = "<users>" + "\n";
		for (User user : a_users)
		{
			//<user name="ituser" password="password" type="ITUser"/>
			output += user.getXmlString() + "\n";
		}
		output += "\n" + "</users>";
		FileOutputStream fos = new FileOutputStream(new File(a_filePath));
		fos.write(output.getBytes());
		fos.flush();
		fos.close();
	}
}
