package com.polycom.sampleapps.servlet.configure;

import java.io.File;
import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: ConfigureServlet</p>
 *
 * <p>Description: Displays IT Manager copnfiguration page.</p>
 *
 * <p>Copyright:* Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ConfigureServlet extends HttpServlet implements SingleThreadModel
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Handles GET request.
	 * Displays IT Manager configuration page after successfully logged in.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile userProfile = appContext.getUserFromCookie(a_request);
		if (userProfile == null)
		{
			errorMessage = "Please login to configure applications.";
			jspPage = "/adminlogin.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			Vector appContents = null;
			Application app = null;
			if (userProfile.getType().equals(Constants.IT_USER_TYPE))
			{
				boolean enabled = false;
				if (a_request.getParameter("op").equals("addstock"))
				{
					app = userProfile.getStockApplication();
					enabled = app.isEnabled();
					appContents = app.getItems();
				}
				else if (a_request.getParameter("op").equals("addrss"))
				{
					app = userProfile.getNewsApplication();
					enabled = app.isEnabled();
					appContents = app.getItems();
				}
				else if (a_request.getParameter("op").equals("addloc"))
				{
					app = userProfile.getWeatherApplication();
					enabled = app.isEnabled();
					appContents = app.getItems();
				}
				else if (a_request.getParameter("op").equals("addtftd"))
				{
					app = userProfile.getThoughtApplication();
					enabled = app.isEnabled();
					//appContents = app.getCommonApps();
				}
				else if (a_request.getParameter("op").equals("adduser"))
				{
					appContents = appContext.getUsers();
				}
				a_request.setAttribute("enabled", "" + enabled);
				a_request.setAttribute("contents", appContents);
				a_request.setAttribute("application", app);
			}
			else
			{
				if (a_request.getParameter("op").equals("addrss"))
				{
					app = userProfile.getNewsApplication();
					appContents = app.getItems();
					a_request.setAttribute("contents", appContents);
				}
			}
			appContext.addUsernameCookieToTheResponse(a_response,
				userProfile.getUser(), false);
			String operation = (String) a_request.getParameter("op");
			a_request.setAttribute("user", userProfile);
			a_request.setAttribute("op", operation);
			jspPage = "/configureapps.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
