package com.polycom.sampleapps.servlet.configure;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistApplications;

/**
 *
 * <p>Title: EnableAppServlet</p>
 *
 * <p>Description: Enable/Disable and updates refresh period of applications.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class EnableAppServlet extends HttpServlet implements SingleThreadModel
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Handles POST request.
	 * Processes enable/disable and refresh period set by the IT Manager and persists the information.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		boolean isITUser = false;
		UserProfile userProfile = appContext.getUserFromCookie(a_request);
		if (userProfile != null)
		{
			if (userProfile.getType().equals(Constants.IT_USER_TYPE))
			{
				isITUser = true;
			}
		}
		if (userProfile == null)
		{
			errorMessage = "Please login to enbale/disable applications.";
			jspPage = "/adminlogin.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			if (isITUser)
			{
				boolean isValidRefreshPeriod = true;
				boolean enabled = false;
				String refreshPeriod = null;
				if (a_request.getParameter("enabled") != null)
				{
					enabled = true;
				}
				if (a_request.getParameter("refreshperiod") != null)
				{
					refreshPeriod = a_request.getParameter("refreshperiod");
					try
					{
						int temp = Integer.parseInt(refreshPeriod);
						if (temp <= 0)
						{
							isValidRefreshPeriod = false;
						}
					}
					catch (NumberFormatException ex)
					{
						isValidRefreshPeriod = false;
					}
				}
				Application app = null;
				Vector appContents = null;
				if (a_request.getParameter("stocks") != null)
				{
					app = userProfile.getStockApplication();
					if (isValidRefreshPeriod)
					{
						app.setIsEnabled(enabled);
						app.setRefreshPeriod(refreshPeriod);
						a_request.setAttribute("contents",
											   userProfile.getStocks());
						a_request.setAttribute("message2",
											   "Stocks configured successfully.");
					}
					else
					{
						a_request.setAttribute("message2",
											   "Please enter valid refresh period.");
					}
					appContents = app.getItems();
					jspPage = "/configureapps.jsp?op=addstock";
				}
				else if (a_request.getParameter("news") != null)
				{
					app = userProfile.getNewsApplication();
					if (isValidRefreshPeriod)
					{
						app.setIsEnabled(enabled);
						app.setRefreshPeriod(refreshPeriod);
						//a_request.setAttribute("contents", userProfile.getNews());
						a_request.setAttribute("message2",
											   "News configured successfully.");
					}
					else
					{
						a_request.setAttribute("message2",
											   "Please enter valid refresh period.");
					}
					appContents = app.getItems();
					jspPage = "/configureapps.jsp?op=addrss";
				}
				else if (a_request.getParameter("weather") != null)
				{
					app = userProfile.getWeatherApplication();
					if (isValidRefreshPeriod)
					{
						app.setIsEnabled(enabled);
						app.setRefreshPeriod(refreshPeriod);
						a_request.setAttribute("contents",
											   userProfile.getWeatherLocations());
						a_request.setAttribute("message2",
											   "Weather configured successfully.");
					}
					else
					{
						a_request.setAttribute("message2",
											   "Please enter valid refresh period.");
					}
					appContents = app.getItems();
					jspPage = "/configureapps.jsp?op=addloc";
				}
				else if (a_request.getParameter("thought") != null)
				{
					app = userProfile.getThoughtApplication();
					if (isValidRefreshPeriod)
					{
						app.setIsEnabled(enabled);
						app.setRefreshPeriod(refreshPeriod);
						a_request.setAttribute("message2",
											   "Thought for the day configured successfully.");
					}
					else
					{
						a_request.setAttribute("message2",
											   "Please enter valid refresh period.");
					}
					jspPage = "/configureapps.jsp?op=addtftd";
				}
				a_request.setAttribute("enabled", "" + enabled);
				a_request.setAttribute("contents", appContents);
				// PERSIST USER
				if (isValidRefreshPeriod)
				{
					try
					{
						String userFilePath = "";
						userFilePath = appContext.getXmlDirPath() +
							Constants.APPLICATIONS_XML_FILE;
						PersistApplications.persist(userProfile, userFilePath);
					}
					catch (IOException ex1)
					{
						ApplicationContext.logger.log(Level.SEVERE,
							ex1.getMessage(), ex1);
					}
				}
				a_request.setAttribute("application", app);
			}
			appContext.addUsernameCookieToTheResponse(a_response,
				userProfile.getUser(), false);
			a_request.setAttribute("user", userProfile);
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
