package com.polycom.sampleapps.servlet.idle;

import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.BlockedThreadInterruptor;

/**
 *
 * <p>Title: IdleServlet</p>
 *
 * <p>Description: Will be ivoked by the idle browser and used to refresh the display with given refresh period.
 * The refresh time will be set by the IT Manager/USER using configuration pages.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class IdleServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Handles GET request.
	 * Invokes RotateApps object to rotate configured applications.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		RotateApps rotateApps = new RotateApps(appContext);
		rotateApps.showNextPage(a_request, a_response);
	}

	public void destroy()
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		if (appContext != null)
		{

			appContext.logger.log(Level.INFO, "Refresh Managers are shutdown");
			appContext.shutdownRefreshManagers();
			BlockedThreadInterruptor.getInstance(appContext).shutdown();
		}
	}
}
