package com.polycom.sampleapps.servlet.idle;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Channel;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.exception.ItemNotRegisteredException;
import com.polycom.sampleapps.servlet.news.NewsManager;
import com.polycom.sampleapps.servlet.stocks.StockBmpConverter;
import com.polycom.sampleapps.servlet.stocks.StockInfo;
import com.polycom.sampleapps.servlet.stocks.StockManager;
import com.polycom.sampleapps.servlet.thought.ThoughtForTheDayManager;
import com.polycom.sampleapps.servlet.weather.WeatherBmpConverter;
import com.polycom.sampleapps.servlet.weather.WeatherInfo;
import com.polycom.sampleapps.servlet.weather.WeatherManager;
import com.polycom.sampleapps.servlet.common.data.User;

/**
 *
 * <p>Title: RotateApps</p>
 *
 * <p>Description: Refresh the idle browser screen with applications and its items on a roatation basis.
 * This will set the refresh header value with the refresh period set by the IT Manager/User.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth.
 * @version 1.0
 */
public class RotateApps
{
	private ApplicationContext m_appContext;
	private String m_applicationId = "";
	private String m_appContentId = "";
	private String m_newsDisplayedIndex = "0";
	private String m_newsDisplayedString = "";

	/**
	 * Constructor with ApplicationContext as argument.
	 * @param a_appContext ApplicationContext
	 */
	public RotateApps(ApplicationContext a_appContext)
	{
		//m_appContext = ApplicationContext.getInstance();
		m_appContext = a_appContext;
	}

	/**
	 * This methos displays next available application and its item.
	 * If applications or items not available then this will display a error message.
	 * @param a_config ServletConfig
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void showNextPage(HttpServletRequest a_request,
							 HttpServletResponse a_response)
	{
		UserProfile user =m_appContext.getUserFromCookie(a_request);		
		setDisplayIds(a_request);
		// GETTING USERNAME
		Vector<Application> applicationList = null;
		boolean appsExists = false;
		if (user == null)
		{
			// ROTATE DEFAULT CONFIGURED APPLICATIONS BY IT-USER
			applicationList = m_appContext.getDefaultEnabledApplications();
			if (applicationList.size() > 0)
			{
				appsExists = true;
			}
		}
		else
		{
			
			m_appContext.addUsernameCookieToTheResponse(a_response,
											   user.getUser(), true);
			applicationList = user.getEnabledApplications();
			if (applicationList.size() > 0)
			{
				appsExists = true;
			}
		}
		if (appsExists)
		{
			if (m_applicationId.getBytes().length == 0)
			{
				Application app = applicationList.get(0);
				m_applicationId = app.getApplicationId();
				m_appContentId = "0";
			}
			boolean areAllAppsRotated = rotateApps(applicationList, a_request,
				a_response, user);
			if (areAllAppsRotated)
			{
				Application app = applicationList.get(0);
				m_applicationId = app.getApplicationId();
				m_appContentId = "0";
				areAllAppsRotated = rotateApps(applicationList, a_request,
											   a_response, user);
				if (areAllAppsRotated)
				{
					String errorMessage = "Applications not configured";
					sendErrorMessage(a_request, a_response, errorMessage);
				}
			}
		}
		else
		{
			String errorMessage = "Applications not configured";
			sendErrorMessage(a_request, a_response, errorMessage);
		}
		//ApplicationContext.logger.log(Level.INFO, "END Response****************************************");
	}

	/**
	 * Iterates through configured applications and displays next available application.
	 * If all application are rotated, it displays applications from starting.
	 * @param applicationList Vector
	 * @param a_config ServletConfig
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 * @param a_user User
	 * @return boolean
	 */
	private boolean rotateApps(Vector<Application> applicationList,
							   HttpServletRequest a_request,
							   HttpServletResponse a_response,
							   UserProfile a_user)
	{
		boolean result = true;
		boolean showNextApp = false;
		for (Application app : applicationList)
		{
			if (showNextApp)
			{
				m_applicationId = app.getApplicationId();
				showNextApp = false;
			}
			if (app.getApplicationId().equals(m_applicationId))
			{
				int appId = Integer.parseInt(m_applicationId);
				switch (appId)
				{
					case 1: // Stocks
					{
						if (showStocksContent(app, a_user, a_request,
											  a_response))
						{
							result = false;
						}
						else
						{
							m_appContentId = "0";
							showNextApp = true;
						}
						break;
					}
					case 2: // Weather
					{
						if (showWeatherContent(app, a_user, a_request,
											   a_response))
						{
							result = false;
						}
						else
						{
							m_appContentId = "0";
							showNextApp = true;
						}
						break;
					}
					case 3: // News
					{
						if (showNewsContent(app, a_request, a_response))
						{
							result = false;
						}
						else
						{
							m_appContentId = "0";
							showNextApp = true;
						}
						break;
					}
					case 4: // Thought For The Day
					{
						if (m_appContentId.getBytes().length == 0)
						{
							m_appContentId = "0";
							showNextApp = true;
						}
						else
						{
							if (showThoughtForTheDay(app, a_request, a_response))
							{
								result = false;
							}
							else
							{
								m_appContentId = "0";
								showNextApp = true;
							}
						}
						break;
					}
					default:
					{
						break;
					}
				}
			}
			if (!result)
			{
				break;
			}
		}
		return result;
	}

	/**
	 * Displays configured news head lines page by page.
	 * @param a_app Application
	 * @param a_config ServletConfig
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 * @param a_user User
	 * @return boolean
	 */
	private boolean showNewsContent(Application a_app,
									HttpServletRequest a_request,
									HttpServletResponse a_response)
	{
		boolean result = false;
		List<Item> news = a_app.getHomePageEnabledItems();
		if (news.size() > 0)
		{
			int newsIndex = 0;
			try
			{
				newsIndex = Integer.parseInt(m_newsDisplayedIndex);
			}
			catch (NumberFormatException ex2)
			{
				newsIndex = 0;
			}
			//System.out.println("m_newsDisplayedIndex :" + m_newsDisplayedIndex);
			//System.out.println("m_newsDisplayedString :" + m_newsDisplayedString);
			if (newsIndex < 4) // four news items are allowed in Main/Idle Browser
			{
				Item rssFeed = news.get(0);
				//ApplicationContext.logger.log(Level.INFO, "Displaying RSS for : " + rssFeed.getName());
				//RefreshManager newsManager = m_appContext.getNewsRefreshManager();
				NewsManager newsManager = m_appContext.getNewsManager();
				Channel channel = (Channel) newsManager.getNewsInfo(rssFeed.
						getContentProviderUrl());
				/*try
				{
					channel = (Channel) newsManager.getNewsInfo(rssFeed.
						getContentProviderUrl());
				}
				catch (ItemNotRegisteredException ex)
				{
					newsManager.register(rssFeed.getContentProviderUrl());
					try
					{
						channel = (Channel) newsManager.getResult(rssFeed.
							getContentProviderUrl());
					}
					catch (ItemNotRegisteredException ex1)
					{
					}
				}*/
				String jspPage = "/rotatenews.jsp";
				m_appContentId = rssFeed.getName();
				setCurrentDisplayIds(a_response);
				a_response.setContentType(Constants.CONTENT_TYPE);
				setRefreshURL(a_response, a_app.getRefreshPeriod());
				if (channel != null)
				{
					a_request.setAttribute("channel", channel);
					a_request.setAttribute("newsindex", new Integer(newsIndex));
					a_request.setAttribute("newsstring", m_newsDisplayedString);
					result = true;
					m_appContext.forward(a_request, a_response, jspPage);
				}
				else
				{
					/*m_newsDisplayedIndex = "0";
					   m_newsDisplayedString = "";
					   setDefaultNewsDisplayIds(a_response);
						  // NEWS FEED NOT AVAILABLE, ROTATE ANOTHER APPLICATION
					 String errorMessage = rssFeed.getName() + " not available.";
					 a_request.setAttribute("errormessage", errorMessage);*/
					//ApplicationContoext.logger.log(Level.INFO, "News not available for : " + rssFeed.getName());
					m_newsDisplayedIndex = "0";
					m_newsDisplayedString = "";
					setDefaultNewsDisplayIds(a_response);
				}
			}
			else
			{
				m_newsDisplayedIndex = "0";
				m_newsDisplayedString = "";
				setDefaultNewsDisplayIds(a_response);
				// NEWS COMPLETED, ROTATE ANOTHER APPLICATION
			}
		}
		return result;
	}

	/**
	 * Displays stock chart
	 * @param a_app Application
	 * @param a_config ServletConfig
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 * @param a_user User
	 * @return boolean
	 */
	private boolean showStocksContent(Application a_app,
									  UserProfile a_userProfile,
									  HttpServletRequest a_request,
									  HttpServletResponse a_response)
	{
		boolean result = false;
		RefreshManager manager = m_appContext.getStockRefreshManager();
		// GET NEXT DISPLAY STOCK SYMBOL
		Item stockQuoteItem = a_app.getNextItem(m_appContentId);
		if (stockQuoteItem == null)
		{
			// STOCKS COMPLETED, ROTATE ANOTHER APPLICATION
		}
		else
		{
			StockManager stockManager = m_appContext.getStockManager();
			StockInfo stockInfo = stockManager.getStockInfo(stockQuoteItem.getName());
			// GET RESULT FROM STOCK QUOTE REFRESH MANAGER
			/*try
			{
				Object obj = manager.getResult(stockQuoteItem.getName());
				if (obj != null && obj instanceof StockInfo)
				{
					stockInfo = (StockInfo) obj;
				}
			}
			catch (ItemNotRegisteredException ex)
			{
				// IF NOT REGISTERED, REGISTER AND GET RESULT
				manager.register(stockQuoteItem.getName());
				try
				{
					Object obj = manager.getResult(stockQuoteItem.getName());
					if (obj != null && obj instanceof StockInfo)
					{
						stockInfo = (StockInfo) obj;
					}
				}
				catch (ItemNotRegisteredException ex1)
				{
				}
			}*/
			// AFTER GETTING THE RESULT FROM MANAGER,
			// CREATE STOCK CHART BMP FILE WITH USERNAME AS THE FILE NAME
			/*String filePath = null;
			try
			{
				filePath = m_appContext.getStocksDirPath() + File.separator +
					getRemoteAddrWithoutDot(a_request.getRemoteAddr()) + ".bmp";
				if (a_userProfile != null)
				{
					File delFile = new File(filePath);
					delFile.delete();
					filePath = m_appContext.getStocksDirPath() + File.separator +
						a_userProfile.getName() + ".bmp";
				}
			}
			catch (Exception ex3)
			{
			}
			try
			{
				StockBmpConverter.convertToBmp(stockInfo, filePath);
			}
			catch (Exception ex2)
			{
			}*/
			// SETTINH CURRENT DISPLAYING ITEM ID
			m_appContentId = stockQuoteItem.getName();
			// SETTING BACK CURRENT DISPLAYED IDS AS COOCKIES
			setCurrentDisplayIds(a_response);
			// SETTING BACK CURRENT NEWS DISPLAYED IDS AS COOCKIES
			setDefaultNewsDisplayIds(a_response);
			a_response.setContentType(Constants.CONTENT_TYPE);
			// SETTING REFRESH PERIOD AND ITS URL AS A HEADER
			setRefreshURL(a_response, a_app.getRefreshPeriod());
			
			//File file = new File(filePath);
			String jspPage = "/rotatestocks.jsp";
			if ((stockInfo != null) && (stockInfo.getBmpFileName() != null))
			{
				a_request.setAttribute("stockbmpfilename", stockInfo.getBmpFileName());
				stockManager.add(stockQuoteItem.getName());
			}
			else
			{
				// STOCK ITEM NOT AVILABLE, ROTATE ANOTHER APPLICATION/STOCK
				String errorMessage = stockQuoteItem.getName() +
					" stock chart not available";
				a_request.setAttribute("errormessage", errorMessage);
			}
			result = true;
			m_appContext.forward(a_request, a_response, jspPage);
		}
		return result;
	}

	/**
	 * Displays weather forecast for Zip/City code.
	 * @param a_app Application
	 * @param a_config ServletConfig
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 * @param a_user User
	 * @return boolean
	 */
	private boolean showWeatherContent(Application a_app,
									   UserProfile a_userProfile,
									   HttpServletRequest a_request,
									   HttpServletResponse a_response)
	{
		boolean result = false;
		Item locationItem = a_app.getNextItem(m_appContentId);
		if (locationItem != null)
		{
			//RefreshManager manager = m_appContext.getWeatherRefreshManager();
			
	/*		// GET RESULT FROM WEATHER REFRESH MANAGER
			try
			{
				Object obj = manager.getResult(locationItem.getName());
				if (obj != null && obj instanceof WeatherInfo)
				{
					weatherInfo = (WeatherInfo) obj;
				}
			}
			catch (ItemNotRegisteredException ex)
			{
				// IF NOT REGISTERED, REGISTER AND GET RESULT
				manager.register(locationItem.getName());
				try
				{
					weatherInfo = (WeatherInfo) manager.getResult(
						locationItem.getName());
				}
				catch (ItemNotRegisteredException ex1)
				{
				}
			}
			// AFTER GETTING THE RESULT FROM MANAGER,
			// CREATE WEATHER STATUS BMP FILE WITH USERNAME AS THE FILE NAME
			String filePath = null;
			try
			{
				filePath = m_appContext.getLocationsDirPath() + File.separator +
					getRemoteAddrWithoutDot(a_request.getRemoteAddr()) + ".bmp";
				if (a_userProfile != null)
				{
					File delFile = new File(filePath);
					delFile.delete();
					filePath = m_appContext.getLocationsDirPath() +
						File.separator + a_userProfile.getName() + ".bmp";
				}
			}
			catch (Exception ex3)
			{
			}
			try
			{
				WeatherBmpConverter.convertToBmp(weatherInfo, filePath);
			}
			catch (Exception ex2)
			{
			}*/
			
			WeatherManager manager=m_appContext.getWeatherManager();
			WeatherInfo weatherInfo = manager.getWeatherInfo(locationItem.getName());
			// SETTINH CURRENT DISPLAYING ITEM ID
			m_appContentId = locationItem.getName();
			// SETTING BACK CURRENT DISPLAYED IDS AS COOCKIES
			setCurrentDisplayIds(a_response);
			// SETTING BACK CURRENT NEWS DISPLAYED IDS AS COOCKIES
			setDefaultNewsDisplayIds(a_response);
			a_response.setContentType(Constants.CONTENT_TYPE);
			// SETTING REFRESH PERIOD AND ITS URL AS A HEADER
			setRefreshURL(a_response, a_app.getRefreshPeriod());
			String jspPage = "/rotatelocations.jsp";
			if (weatherInfo == null || weatherInfo.getBmpFileName()==null)
			{
				// LOCATION NOT AVAILABLE, ROTATE ANOTHER APPLICATION/LOCATION
				String errorMessage = locationItem.getName() +
					" weather forecast not available";
				a_request.setAttribute("errormessage", errorMessage);
			}
			else
			{
				a_request.setAttribute("weatherinfo", weatherInfo);
				a_request.setAttribute("location", locationItem);
				a_request.setAttribute("locationbmpfilename", weatherInfo.getBmpFileName());
			}
			result = true;
			m_appContext.forward(a_request, a_response, jspPage);
		}
		else
		{
			// LOCATIONS COMPLETED, ROTATE ANOTHER APPLICATION
		}
		return result;
	}

	/**
	 * Displays todays Thought Of The Day.
	 * @param a_app Application
	 * @param a_config ServletConfig
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 * @param a_user User
	 * @return boolean
	 */
	private boolean showThoughtForTheDay(Application a_app,
										 HttpServletRequest a_request,
										 HttpServletResponse a_response)
	{
		boolean result = false;
		// GETTING TEXT FROM THOUGHT OF THE DAY REFRESH MANAGER
		ThoughtForTheDayManager refreshManger = m_appContext.getThoughtRefreshManager();
		String displayText = (String) refreshManger.getMessage();
		/*try
		{
			
		}
		catch (ItemNotRegisteredException ex)
		{
		}*/
		m_appContentId = "";
		setCurrentDisplayIds(a_response);
		a_response.setContentType(Constants.CONTENT_TYPE);
		setDefaultNewsDisplayIds(a_response);
		setRefreshURL(a_response, a_app.getRefreshPeriod());
		//ApplicationContext.logger.log(Level.INFO, "Displaying Thought For The Day");
		if (displayText != null)
		{
			result = true;
			a_request.setAttribute("displaytext", displayText);
			m_appContext.forward(a_request, a_response, "/rotatethought.jsp");
		}
		else
		{
			//ApplicationContext.logger.log(Level.INFO, "TFTD not available");
		}
		return result;
	}

	/**
	 * Sends error message to the idle browser
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 * @param a_errorMessage String
	 */
	private void sendErrorMessage(HttpServletRequest a_request,
								  HttpServletResponse a_response,
								  String a_errorMessage)
	{
		a_request.setAttribute("errormessage", a_errorMessage);
		//m_appContext.forward(a_request, a_response, "appsna.jsp");
		String output = "";
		output = getHeader("");
		ApplicationContext.logger.log(Level.SEVERE, "In Error-> " +a_errorMessage);
		output += "<p>" + a_errorMessage + "</p>";
		output += getFooter();
		a_response.setContentType(Constants.CONTENT_TYPE);
		setRefreshURL(a_response,
					  Constants.APPLICATIONS_NOT_AVAILABLE_REFRESH_PERIOD);
		try
		{
			OutputStream os = a_response.getOutputStream();
			os.write(output.getBytes());
			os.flush();
			os.close();
		}
		catch (IOException ex1)
		{
			//ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(), ex1);
		}

	}

	/**
	 * Sets default XHTML header to the response
	 * @param a_title String
	 * @return String
	 */
	private String getHeader(String a_title)
	{
		String result = "";
		result += "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
		result += "<head>";
		result += "<title>" + a_title + "</title>";
		result += "</head>";
		result += "<body>";
		return result;
	}

	/**
	 * Sets default XHTML footer to the response
	 * @return String
	 */
	private String getFooter()
	{
		String result = "";
		result += "</body>";
		result += "</html>";
		return result;
	}

	/**
	 * Sets refresh header with given refresh period
	 * @param a_response HttpServletResponse
	 * @param a_refreshPeriod String
	 */
	private void setRefreshURL(HttpServletResponse a_response,
							   String a_refreshPeriod)
	{
		try
		{
			String ipAddr = getHostAddress();
			a_response.setHeader("Refresh",
								 a_refreshPeriod + "; url=http://" +
								 ipAddr + ":8080/sampleapps/idle");
		}
		catch (Exception ex1)
		{
		}
	}

	/**
	 * Sets current displayed application and its item.
	 * @param a_request HttpServletRequest
	 */
	private void setDisplayIds(HttpServletRequest a_request)
	{
		Cookie[] cookies = a_request.getCookies();
		/////////TEMPORARY CODE TO WORK WITH SIMULATOR///////////////
		/*Enumeration enum1 = a_request.getHeaderNames();
		int count = 0;
		while (enum1.hasMoreElements())
		{
			String ele = (String) enum1.nextElement();
			String val = a_request.getHeader(ele);
			if ( (ele.startsWith("Set-Cookie") || ele.startsWith("set-cookie")) &&
				(val.startsWith(Constants.APPLICATION_COOKIE_IDLE) ||
				 val.startsWith(Constants.APP_CONTENT_COOKIE_IDLE) ||
				 val.startsWith(Constants.NEWS_DISPLAYED_INDEX) ||
				 val.startsWith(Constants.NEWS_DISPLAYED_STRING)))
			{
				//System.out.println(ele + " : COOKIE : " + val);
				if (cookies == null)
				{
					cookies = new Cookie[4];
				}
				StringTokenizer stk = new StringTokenizer(val, "=");
				String str1 = "";
				String str2 = "";
				if (stk.countTokens() == 2)
				{
					str1 = stk.nextToken();
					str2 = stk.nextToken();
				}
				else
				{
					str1 = stk.nextToken();
				}
				cookies[count] = new Cookie(str1, str2);
				count++;
			}
		}*/
		/////////END TEMPORARY CODE TO WORK WITH SIMULATOR///////////////
		if (cookies != null)
		{
			for (Cookie cookie : cookies)
			{
				if (cookie.getName().equals(Constants.APPLICATION_COOKIE_IDLE))
				{
					m_applicationId = cookie.getValue();
				}
				else if (cookie.getName().equals(Constants.
												 APP_CONTENT_COOKIE_IDLE))
				{
					m_appContentId = cookie.getValue();
				}
				else if (cookie.getName().equals(Constants.
												 NEWS_DISPLAYED_INDEX))
				{
					m_newsDisplayedIndex = cookie.getValue();
				}
				else if (cookie.getName().equals(Constants.
												 NEWS_DISPLAYED_STRING))
				{
					m_newsDisplayedString = cookie.getValue();
				}
			}
		}
	}

	/**
	 * Sets current displaying application and its item to the Cookie
	 * @param a_response HttpServletResponse
	 */
	private void setCurrentDisplayIds(HttpServletResponse a_response)
	{
		a_response.addCookie(new Cookie(Constants.APPLICATION_COOKIE_IDLE,
										m_applicationId));
		a_response.addCookie(new Cookie(Constants.APP_CONTENT_COOKIE_IDLE,
										m_appContentId));
	}

	/**
	 * Sets default news index and last displayed news item
	 * @param a_response HttpServletResponse
	 */
	private void setDefaultNewsDisplayIds(HttpServletResponse a_response)
	{
		a_response.addCookie(new Cookie(Constants.NEWS_DISPLAYED_INDEX, "0"));
		a_response.addCookie(new Cookie(Constants.NEWS_DISPLAYED_STRING, ""));
	}

	/**
	 * Getting host address to add it on the refresh header
	 * @return String
	 */
	private String getHostAddress()
	{
		String result = "";
		try
		{
			Enumeration<NetworkInterface> nets = NetworkInterface.
				getNetworkInterfaces();
			for (NetworkInterface netint : Collections.list(nets))
			{
				Enumeration<InetAddress> inetAddresses = netint.
					getInetAddresses();
				for (InetAddress inetAddress : Collections.list(inetAddresses))
				{

					if (!inetAddress.isLoopbackAddress()&& !inetAddress.isLinkLocalAddress())
					{
						result = inetAddress.getHostAddress();
					}
				}
			}
		}
		catch (SocketException ex)
		{
		}
		return result;
	}

	private String getRemoteAddrWithoutDot(String a_remoteAddr)
	{
		String result = "";
		StringTokenizer stk = new StringTokenizer(a_remoteAddr, ".");
		while (stk.hasMoreTokens())
		{
			result += stk.nextToken();
		}
		return result;
	}
}
