package com.polycom.sampleapps.servlet.news;

import java.io.IOException;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Channel;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistApplications;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;
import com.polycom.sampleapps.servlet.exception.RssFeedAlreadyExistException;

/**
 *
 * <p>Title: AddRssFeedServlet</p>
 *
 * <p>Description:Adds the new RSS feed for ADMIN/USER.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class AddRssFeedServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from configurerss.jsp page to add the new RSS feed for UER/ADMIN
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String message = "";
		String jspPage = "";
		boolean isRssAdded = false;
		boolean isItUser = false;
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		Application app = null;
		if (user != null)
		{
			app = user.getNewsApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
			}
		}
		if (user == null)
		{
			message = "Please login to add RSS feed.";
		}
		else
		{
			String rssname = a_request.getParameter("rssname");
			String rssurl = a_request.getParameter("rssurl");
			NewsManager manager=appContext.getNewsManager();
			
			//RefreshManager manager = appContext.getNewsRefreshManager();
			boolean isExist = manager.isNewsExists(rssurl);
			if (!isExist)
			{
				message=manager.isValidRssFeed(rssurl);
				if ( message.length() == 0 )
				{
					isExist = true;
					manager.add(rssurl);
				}
				
				/*try
				{
				
					
					manager.register(rssurl);
					for (int i = 0; i < Constants.NUMBER_OF_RETRIES; i++)
					{
						Channel channel = (Channel) manager.getResult(rssurl);
						if (channel != null)
						{
							isExist = true;
							break;
						}
					}
				}
				catch (Exception ex)
				{
				}*/
			}
			try
			{
				if (!isExist)
				{
					message = "Invalid RSS feed '" + rssname + "'";
				}
				else
				{
					user.addRSS(rssname, rssurl);
					message = "'" + rssname + "' added successfully.";
					// REGISTER THE ADDED NEWS WITH REFRESH MANAGER
					if ( !user.isITUser() )
					{
						appContext.getNewsRefreshManager().register(rssurl);
					}
					isRssAdded = true;
				}
			}
			catch (RssFeedAlreadyExistException ex1)
			{
				message = ex1.getMessage();
			}
		}
		if (isRssAdded)
		{
			// PERSIST USER
			try
			{
				String userFilePath = "";
				if (isItUser)
				{
					userFilePath = appContext.getXmlDirPath() +
						Constants.APPLICATIONS_XML_FILE;
					PersistApplications.persist(user, userFilePath);
				}
				else
				{
					userFilePath = appContext.getXmlDirPath() + user.getName() +
						".xml";
					PersistUser.persist(user, userFilePath);
				}
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			if (isItUser)
			{
				a_request.setAttribute("application", app);
				a_request.setAttribute("enabled", "" + app.isEnabled());
				a_request.setAttribute("contents", app.getItems());
				a_request.setAttribute("message", message);
				a_request.setAttribute("user", user);
				jspPage = "/configureapps.jsp?op=addrss";
			}
			else
			{
				a_request.setAttribute("application", app);
				a_request.setAttribute("contents", app.getItems());
				a_request.setAttribute("message", message);
				a_request.setAttribute("user", user);
				jspPage = "/configureapps.jsp?op=addrss";
			}
		}
		else
		{
			if (a_request.getParameter("configure") != null)
			{
				if (user == null)
				{
					a_request.setAttribute("errormessage", message);
					jspPage = "/adminlogin.jsp";
				}
				else
				{
					a_request.setAttribute("application", app);
					a_request.setAttribute("contents", app.getItems());
					a_request.setAttribute("enabled", "" + app.isEnabled());
					a_request.setAttribute("user", user);
					a_request.setAttribute("message", message);
					jspPage = "/configureapps.jsp?op=addrss";
				}
			}
			else
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/adminlogin.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from configurerss.jsp page for UER/ADMIN to display News page.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		Application app = null;
		if (user != null)
		{
			app = user.getNewsApplication();
			a_request.setAttribute("application", app);
			a_request.setAttribute("enabled", "" + app.isEnabled());
			a_request.setAttribute("contents", app.getItems());
			a_request.setAttribute("user", user);
			jspPage = "/configureapps.jsp?op=addrss";
		}
		else
		{
			String message = "Please login to add RSS news feeds.";
			if (a_request.getParameter("configure") != null)
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/adminlogin.jsp";
			}
			else
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/login.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
