package com.polycom.sampleapps.servlet.news;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Vector;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.protocol.BufferingHttpClientHandler;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;

import com.polycom.sampleapps.servlet.stocks.SymbolKey;


/**
*
* <p>Title: NIOForNews</p>
*
* <p>Description: The class uses apache NIO to update the news content for given url.
* It create sockets for every rss feed ,connects to the url given,gets the data from site and updates the news information in News Channel map.
* </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class NIOForNews {

	//List of rss feeds that needs to be updated
	private Vector<String> m_currentActiveNewsVec;

	private NewsChannelCreator m_newsChannelCreator;
	
	private ConnectingIOReactor ioReactor;

	public NIOForNews(Vector<String> currentActiveNewsVec,
			NewsChannelCreator channelCreator) {
		m_currentActiveNewsVec = currentActiveNewsVec;
		m_newsChannelCreator = channelCreator;

		final HttpParams params = new BasicHttpParams(null);
		params
				.setIntParameter(HttpConnectionParams.SO_TIMEOUT, 50000)
				.setIntParameter(HttpConnectionParams.CONNECTION_TIMEOUT,
						70000)
				.setIntParameter(HttpConnectionParams.SOCKET_BUFFER_SIZE,
						8 * 1024)
				.setBooleanParameter(
						HttpConnectionParams.STALE_CONNECTION_CHECK, false)
				.setBooleanParameter(HttpConnectionParams.TCP_NODELAY, true)
				.setParameter(HttpProtocolParams.USER_AGENT,
						"Jakarta-HttpComponents-NIO/1.1");

		try {
			ioReactor = new DefaultConnectingIOReactor(2, params);
			BasicHttpProcessor httpproc = new BasicHttpProcessor();
			httpproc.addInterceptor(new RequestContent());
			httpproc.addInterceptor(new RequestTargetHost());
			httpproc.addInterceptor(new RequestConnControl());
			httpproc.addInterceptor(new RequestUserAgent());
			httpproc.addInterceptor(new RequestExpectContinue());

			BufferingHttpClientHandler handler = new BufferingHttpClientHandler(
					httpproc, new MyNewsHttpRequestExecutionHandler(),
					new NoConnectionReuseStrategy(), params);

			final IOEventDispatch ioEventDispatch = new DefaultClientIOEventDispatch(
					handler, params);

			Thread t = new Thread(new Runnable() {
				public void run() {
					try {
						ioReactor.execute(ioEventDispatch);
					} catch (InterruptedIOException ex) {
						System.err.println("Interrupted");
					} catch (IOException e) {
						System.err.println("I/O error: " + e.getMessage());
					}
				}
			});
			t.start();

			SessionRequest[] reqs = new SessionRequest[m_currentActiveNewsVec.size()];
			for (String newsRSS : m_currentActiveNewsVec) {
				URL url = new URL(newsRSS);
				String hostAddress = url.getHost();
				String uri = url.getPath();
				SymbolKey quoteKey = new SymbolKey(uri, new HttpHost(hostAddress));
			    reqs[0] = ioReactor.connect(new InetSocketAddress(hostAddress,80), null, quoteKey, null);
			}

		}
		catch (Exception e) {
		}
	}
	
	/**
	 * Closes all the opened socket channel
	 *
	 */
	public void shutDownClient()
	{
		try {
			if (ioReactor != null)
				ioReactor.shutdown();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Description:Used to initialize the connection,submitting the request and handling the response.
	 * The data obtained in response is updated in news table for creating news channel objects
	 * @author smarella
	 *
	 */
	class MyNewsHttpRequestExecutionHandler implements HttpRequestExecutionHandler {

		public void initalizeContext(final HttpContext context,
				final Object attachment) {
			// HttpHost targetHost = (HttpHost) attachment;
			SymbolKey chartKey = (SymbolKey) attachment;
			context.setAttribute("URI", chartKey.getURI());
			context.setAttribute(HttpExecutionContext.HTTP_TARGET_HOST,
					chartKey.getHttpHost()); // targetHost);
		}

		public HttpRequest submitRequest(final HttpContext context) {

			/*HttpHost targetHost = (HttpHost) context
					.getAttribute(HttpExecutionContext.HTTP_TARGET_HOST);*/			
			// System.out.println("--------------");
			// System.out.println("Sending request to " + targetHost);
			// System.out.println("--------------");
			String uri = (String) context.getAttribute("URI");
			BasicHttpRequest req = new BasicHttpRequest("GET", uri);
			return req;
		}

		public void handleResponse(final HttpResponse response,
				final HttpContext context) {
			HttpEntity entity = response.getEntity();
			String url = "";
			HttpHost host = (HttpHost) context.getAttribute("http.target_host");
			url += host.getSchemeName() + "://" + host.getHostName();
			String uri = (String) context.getAttribute("URI");
			url += uri;
			if (!uri.equals("")&&m_newsChannelCreator!=null) {				
				try {
					m_newsChannelCreator.getNewsTable().put(url,
							EntityUtils.toString(entity));
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}

	}

	public static void main(String[] args) {
		/*
		 * String url="http://rss.news.yahoo.com/rss/topstories"; Vector<String>
		 * newsVector=new Vector<String>(); newsVector.add(url); NIOForNews
		 * nn=new NIOForNews(newsVector);
		 */
	}

}
