package com.polycom.sampleapps.servlet.news;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.Channel;
import com.polycom.sampleapps.servlet.common.parsers.RssXmlParser;

/**
*
* <p>Title: NewsChannelCreator</p>
*
* <p>Description: This class creates news channel object which will be used to send response to the client
* In this for every 20 min the news managers content table is updated using the information obtained from NIOForNews
* </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*
*/

public class NewsChannelCreator extends Thread {

	private NewsManager m_manager;

	//Rss feed - data map
	private Hashtable<String, String> m_newsContentTable;//Key-> Rss feed,Value-> Rss feed data obtained from internet

	public NewsChannelCreator(NewsManager manager) {
		m_manager = manager;
		m_newsContentTable = new Hashtable<String, String>();
	}

	/**
	 * Creates Channels for every RSS Feed available in manager
	 */
	public void run() {
		while (true) {
			try {				
				Vector<String> newsFeeds = m_manager.getActiveNews();		
					for (String feed : newsFeeds) {
						RssXmlParser parser = new RssXmlParser();
						if (m_newsContentTable.get(feed) != null) {
							Channel channel = parser.parseRssXML(m_newsContentTable
									.get(feed));
							m_manager.getNewsChannelTable().put(feed, channel);
							parser=null;
						}
					}
				
			} catch (Exception e) {
				ApplicationContext.logger.log(Level.SEVERE,
						  "Got exception while parsing news: ");
			}
			try {
				this.sleep(20*1000 * 60);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	public Hashtable<String, String> getNewsTable() {
		return m_newsContentTable;
	}

}
