package com.polycom.sampleapps.servlet.news;

import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;

/**
*
* <p>Title: NewsDataProcessor</p>
*
* <p>Description: Updates the news content for every 15 min through socket channel using NIOForNews </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class NewsDataProcessor extends Thread {

	private NewsManager m_newsManager;

	private Hashtable<String, String> m_newsContentTable; // Key--> Rss URL

	// ,Value--> content
	private NewsChannelCreator channelCreator;

	private NIOForNews client;

	public NewsDataProcessor(NewsManager newsManager) {
		m_newsManager = newsManager;
		m_newsContentTable = new Hashtable<String, String>();
		channelCreator = new NewsChannelCreator(m_newsManager);
		channelCreator.setName("NewsDataProcessor");
		channelCreator.start();		
	}

	/**
	 * Collectes all the news feeds from manager and checks if news content is accesed by client or not for time interval of 5 min
	 * If it is accesed then those news content will be updated by NIOForNews 
	 */
	public void run() {
		while (true) {
			Vector<String> newsFeeds = m_newsManager.getActiveNews();	
			
			long currTime = System.currentTimeMillis();		
			Vector<String> temp=new Vector<String>();
			HashMap<String, Long> stockAccessMap = m_newsManager.getNewsAccessMap();
			for(String symbol:newsFeeds)
			{
				if(stockAccessMap.containsKey(symbol)&&
						(currTime-stockAccessMap.get(symbol))>ApplicationContext.UNUSED_PERIOD)
				{
					//m_stockMgr.delete(symbol);
				}				
				else if(!stockAccessMap.containsKey(symbol))
				{
					//m_stockMgr.delete(symbol);
				}else
				{
					temp.add(symbol);
				}
			}
			//System.out.println("News Count:"+temp.size());
			if(temp.size()>0)
			{
				client = new NIOForNews(temp, channelCreator);
				//ApplicationContext.logger.log(Level.INFO, "News updated at"+new Date());
			}
			try {
				this.sleep(Constants.NEWS_REFRESH_RATE);
				if (client != null) {
					client.shutDownClient();
					client = null;
				}
			} catch (Exception e) {
				//System.out.println("Got exception in news data processor");
			}
			
		}
	}

}
