package com.polycom.sampleapps.servlet.news;

import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.ContentReader;
import com.polycom.sampleapps.servlet.common.Reader;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Channel;
import com.polycom.sampleapps.servlet.common.parsers.RssXmlParser;

public class NewsReader implements Reader
{
	private static NewsReader m_self;
	private Hashtable<String, Channel> m_newsChannelTable;
	private Hashtable<String, Long> m_newsAccessedTimeTable;
	private RefreshManager m_manager;

	private NewsReader(RefreshManager a_manager)
	{
		m_manager = a_manager;
		m_newsChannelTable = new Hashtable<String, Channel> ();
		m_newsAccessedTimeTable = new Hashtable<String, Long> ();
	}

	public static NewsReader getInstance(RefreshManager a_manager)
	{
		if (m_self == null)
		{
			m_self = new NewsReader(a_manager);
		}
		return m_self;
	}

	/**
	 * Checks for last accssed time, if it exceeds beyond the specified accessed time, then unregister this RSS News feed from cache.
	 * If it is with in specified access time limit, reads RSS news feed (XML format) from given content provider site.
	 * After reading, parses the XML content and creates Channel object and then caches it.
	 * @param a_itemName String
	 * @return Object
	 */
	public Object read(String a_itemName)
	{
		//ApplicationContext.logger.log(Level.INFO, a_itemName + " READING STARTED...........");
		Channel channel = null;
		while (true)
		{
			try
			{
				// CHECKING FOR LAST ACCESSED TIME, IF IT IS MORE THAN 5 MINS, THEN UNREGISTER THIS ITEM
				Object obj = m_newsAccessedTimeTable.get(a_itemName);
				if (obj != null)
				{
					long lastAccessedTime = ( (Long) obj).longValue();
					long currentTime = System.currentTimeMillis();
					long meanTime = currentTime - lastAccessedTime;
					if (meanTime >= Constants.UNREGISTER_ITEM_FROM_CACHE_TIME)
					{
						m_newsAccessedTimeTable.remove(a_itemName);
						m_manager.unregister(a_itemName);
						return channel;
					}
				}
				String rssUrl = a_itemName;
				String rssContent = ContentReader.getContent(rssUrl);
				RssXmlParser parser = new RssXmlParser();
				channel = parser.parseRssXML(rssContent);
				m_newsChannelTable.put(a_itemName, channel);
				//ApplicationContext.logger.log(Level.INFO, "Last Updated: " + a_itemName + " :" + new Date().toString());
				break;
			}
			catch (Exception ex)
			{
				//ApplicationContext.logger.log(Level.SEVERE, a_itemName + " : " + ex.getMessage());
			}
		}
		return channel;
	}

	/**
	 * Updates the last accessed time and returns the latest RSS News feed information.
	 * @param a_itemName String
	 * @return Object
	 */
	public Object getResult(String a_itemName)
	{
		m_newsAccessedTimeTable.put(a_itemName, System.currentTimeMillis());
		return m_newsChannelTable.get(a_itemName);
	}

	public void deleteCache(String a_itemName)
	{
		m_newsChannelTable.remove(a_itemName);
		m_newsAccessedTimeTable.remove(a_itemName);
	}
}
