package com.polycom.sampleapps.servlet.news;

import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Channel;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.exception.ItemNotRegisteredException;

/**
 *
 * <p>Title: ViewNewsServlet</p>
 *
 * <p>Description: This servlet fetches the configured news content and displays first four news items to the user.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class ViewNewsServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from applications.jsp to display configured RSS news.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String errorMessage = "";
		String jspPage = "";
		UserProfile user = appContext.getUserFromCookie(a_request);
		// CHECK FOR USERNAME
		if (user == null)
		{
			errorMessage = "Please login to view news page.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			// STEP 2: GET STOCKS FROM CACHE
			Channel channel = null;
			boolean isItemExist = false;
			Vector<Item> news = user.getNews();
			Item rss = null;
			if (news.size() > 0)
			{
				rss = news.get(0);
				NewsManager newsManager = appContext.getNewsManager();
				//RefreshManager refreshManager = appContext.		getNewsRefreshManager();
				//try
				//{
					channel = newsManager.getNewsInfo(rss.
						getContentProviderUrl());
					if(channel!=null)
						isItemExist = true;
				//}
				/*catch (ItemNotRegisteredException ex)
				{
				}*/
			}
			if (isItemExist)
			{
				a_request.setAttribute("channel", channel);
				a_request.setAttribute("rss", rss);
			}
			else if(rss!=null)
			{
				errorMessage = rss.getName() + " not available.";
				a_request.setAttribute("errormessage", errorMessage);
			}
			else
			{
				errorMessage = "news not configured";
				a_request.setAttribute("errormessage", errorMessage);
			}
			jspPage = "/viewnews.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
