package com.polycom.sampleapps.servlet.stocks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.exception.ItemNotRegisteredException;
import com.polycom.sampleapps.servlet.exception.StockAlreadyExistException;

/**
 *
 * <p>Title: AddStockServlet</p>
 *
 * <p>Description: This servlet will handle request from IT manager/USER configuration to add the stock.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class AddStockServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from configurestock.jsp and viewstocks.jsp page to add the stock symbol for IT Manager/USER.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String message = "";
		String jspPage = "";
		boolean isStockAdded = false;
		boolean isStockAddFailed = false;
		boolean isItUser = false;
		
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		Application app = null;
		if (user != null)
		{
			app = user.getStockApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
				a_request.setAttribute("enabled", "" + app.isEnabled());
			}
		}
		String stockname = a_request.getParameter("stockname");
		if (user == null)
		{
			message = "Please login to add Stocks.";
		}
		else
		{
			if (stockname == null || stockname.getBytes().length <= 0)
			{
				message = "Please enter valid stock symbol.";
				isStockAddFailed = true;
			}
			else
			{
				StockManager stockManager = appContext.getStockManager();
				//RefreshManager manager = appContext.getStockRefreshManager();
				//boolean isExist = manager.isItemExist(stockname);
				boolean isExist = stockManager.isSymbolExists(stockname);
				if (!isExist)
				{
					
					//System.out.println("Adding stocks.........");
					message = stockManager.isValidStockSymbol(stockname);
					if ( message.length() == 0 )
					{
						isExist = true;
						stockManager.add(stockname);
					}
					//manager.register(stockname);
					/*StockInfo stockInfo = null;
					try
					{
						
						for (int i = 0; i < Constants.NUMBER_OF_RETRIES; i++)
						{
							stockInfo = (StockInfo) manager.getResult(stockname);
							if (stockInfo != null)
							{
								break;
							}
						}
					}
					catch (ItemNotRegisteredException ex)
					{
					}
					if (stockInfo != null)
					{
						if (stockInfo.getLastTrade() != null &&
							stockInfo.getLastTrade().length() > 0)
						{
							isExist = true;
						}
						else
						{
							message = "Please enter valid stock symbol.";
						}
					}
					else
					{
						//manager.unregister(stockname);
						message =
							"Unable to add Stocks. Please try after some time.";
					}*/
				}
				if (isExist)
				{
					try
					{
						user.addStock(stockname);
						message = "'" + stockname + "' added successfully.";
						// REGISTER THE ADDED STOCK QUOTE WITH REFRESH MANAGER
						/*if (!user.isITUser())
						{
							manager.register(stockname);
						}*/
						isStockAdded = true;
					}
					catch (StockAlreadyExistException ex1)
					{
						isStockAddFailed = true;
						message = ex1.getMessage();
					}
				}
				else
				{
					isStockAddFailed = true;
				}
			}
		}
		if (isStockAdded || (isStockAddFailed && !isItUser))
		{
			// PERSIST USER
			try
			{
				user.persistUserProfile(appContext);
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			if (isItUser)
			{
				appContext.addUsernameCookieToTheResponse(a_response,
					user.getUser(), false);
				a_request.setAttribute("contents", app.getItems());
				a_request.setAttribute("application", app);
				a_request.setAttribute("message", message);
				a_request.setAttribute("user", user);
				jspPage = "/configureapps.jsp?op=addstock";
			}
			else
			{
				Vector<Item> stocks = user.getStocks();
				if (isStockAddFailed)
				{
					a_request.setAttribute("message", message);
					if(!stocks.isEmpty())
					{
						//Item stock = stocks.get(0);
						List<Item> dispStocks = new ArrayList<Item> ();
						dispStocks.addAll(stocks);
						//dispStocks.remove(0);
						a_request.setAttribute("stocks", dispStocks);
						// a_request.setAttribute("stock", stock);
						// a_request.setAttribute("stockbmpfile", "");
						jspPage = "/viewstocks.jsp";
					}
				}
				else if (stocks.size() > 0)
				{
					boolean bmpConvert = true;
					if (bmpConvert)
					{
						Item stock = stocks.get(0);
						a_request.setAttribute("stock", stock);
						a_request.setAttribute("stocks", user.getStocks());
					}
					else
					{
						String errorMessage = stockname +
							" chart not available";
						a_request.setAttribute("errormessage", errorMessage);
					}
					a_response.setHeader("Expires", "0");
					jspPage = "/viewstocks.jsp";
				}
			}
		}
		else
		{
			if (a_request.getParameter("configure") != null)
			{
				if (user == null)
				{
					a_request.setAttribute("errormessage", message);
					jspPage = "/adminlogin.jsp";
				}
				else
				{
					a_request.setAttribute("contents", app.getItems());
					a_request.setAttribute("user", user);
					a_request.setAttribute("message", message);
					jspPage = "/configureapps.jsp?op=addstock";
				}
			}
			else
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/login.jsp";
			}
		}
		if(jspPage==null||jspPage.trim().equals(""))
		{
			if (user == null)
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/adminlogin.jsp";
			}
			else
			{
				message =
					"Unable to add Stocks/Invalid stock. Please try after some time.";
				a_request.setAttribute("errormessage", message);
				jspPage = "/viewstocks.jsp";
			}
		}	
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from configurestock.jsp and viewstocks.jsp page for IT Manager/USER.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String jspPage = "";
		UserProfile user = appContext.getUserFromCookie(a_request);
		Application app = null;
		if (user != null)
		{
			boolean isItUser = false;
			app = user.getStockApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
				a_request.setAttribute("enabled", "" + app.isEnabled());
				a_request.setAttribute("application", app);
			}
			if (isItUser)
			{
				appContext.addUsernameCookieToTheResponse(a_response,
					user.getUser(), false);
				a_request.setAttribute("contents", app.getItems());
				a_request.setAttribute("application", app);
				a_request.setAttribute("user", user);
				jspPage = "/configureapps.jsp?op=addstock";
			}
			else
			{
				Vector<Item> stocks = user.getStocks();
				if (stocks.size() > 0)
				{
					Item stock = stocks.get(0);
					List<Item> dispStocks = new ArrayList<Item> ();
					dispStocks.addAll(stocks);
					//dispStocks.remove(0);
					a_request.setAttribute("stocks", dispStocks);
					a_request.setAttribute("stock", stock);
					a_request.setAttribute("stockbmpfile", "");
				}
				else
				{
					a_request.setAttribute("message", "Stocks not configured.");
				}
				jspPage = "/viewstocks.jsp";
			}
		}
		else
		{
			String message = "Please login to add stock symbols";
			if (a_request.getParameter("configure") != null)
			{
				a_request.setAttribute("errormessage", message);
				a_request.setAttribute("configure", "");
				jspPage = "/login.jsp";
			}
			else
			{
				a_request.setAttribute("errormessage", message);
				jspPage = "/login.jsp?ub";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
