package com.polycom.sampleapps.servlet.stocks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistApplications;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;

/**
 *
 * <p>Title: ConfigureStockServlet</p>
 *
 * <p>Description: This servlet configures (Add/Delete from home page) stocks for IT Manager/USER</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ConfigureStockServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from viewstocks.jsp page to configure stokcs for USER
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());

		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to configure Stocks.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "/login.jsp";
		}
		else
		{
			String stockName = "";
			boolean delete = false;
			if (a_request.getParameter("delstockhome") != null)
			{
				stockName = a_request.getParameter("delstockhome");
				user.deleteStockFromHomePage(stockName);
				delete = true;
			}
			else if (a_request.getParameter("addstockhome") != null)
			{
				stockName = a_request.getParameter("addstockhome");
				user.addStockToHomePage(stockName);
			}
			// PERSIST USER
			try
			{
				String userFilePath = appContext.getXmlDirPath() +
					user.getName() + ".xml";
				PersistUser.persist(user, userFilePath);
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			{
				Vector<Item> stocks = user.getStocks();
				List<Item> dispStocks = new ArrayList<Item> ();
				Application app = user.getStockApplication();
				Item stock = null;
				int index = 0;
				for (Item cApp : app.getItems())
				{
					if (cApp.getName().equals(stockName))
					{
						stock = cApp;
						break;
					}
					index++;
				}
				if (delete)
				{
					user.getStocks().remove(index);
					user.getStocks().add(stock);
				}
				else
				{
					user.getStocks().remove(index);
					user.getStocks().add(0, stock);
				}
				dispStocks.addAll(stocks);
				//dispStocks.remove(0);
				a_request.setAttribute("stocks", dispStocks);
				a_request.setAttribute("stock", stock);
				a_request.setAttribute("stockbmpfile", "");
				jspPage = "/viewstocks.jsp";
			}
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from addstocks.jsp page to configure stocks for IT Manager
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		boolean isItUser = false;
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			Application app = user.getStockApplication();
			if (user.getType().equals(Constants.IT_USER_TYPE))
			{
				isItUser = true;
				a_request.setAttribute("enabled", "" + app.isEnabled());
				a_request.setAttribute("application", app);
			}
		}
		if (user == null)
		{
			errorMessage = "Please login to configure Stocks.";
			a_request.setAttribute("errormessage", errorMessage);
			jspPage = "/adminlogin.jsp";
		}
		else
		{
			String stockName = "";
			if (a_request.getParameter("delstockhome") != null)
			{
				stockName = a_request.getParameter("delstockhome");
				user.deleteStockFromHomePage(stockName);
				a_request.setAttribute("message1",
									   stockName + " disabled for home page.");
			}
			else if (a_request.getParameter("addstockhome") != null)
			{
				stockName = a_request.getParameter("addstockhome");
				user.addStockToHomePage(stockName);
				a_request.setAttribute("message1",
									   stockName + " enabled for home page.");
			}
			else if (a_request.getParameter("delstock") != null)
			{
				stockName = a_request.getParameter("delstock");
				user.deleteStock(stockName);
				a_request.setAttribute("message1",
									   stockName + " deleted successfully.");
			}
			// PERSIST USER
			try
			{
				String userFilePath = "";
				if (isItUser)
				{
					userFilePath = appContext.getXmlDirPath() +
						Constants.APPLICATIONS_XML_FILE;
					PersistApplications.persist(user, userFilePath);
				}
				else
				{
					userFilePath = appContext.getXmlDirPath() + user.getName() +
						".xml";
					PersistUser.persist(user, userFilePath);
				}
			}
			catch (IOException ex1)
			{
				ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
											  ex1);
			}
			appContext.addUsernameCookieToTheResponse(a_response, user.getUser(), false);
			Vector<Item> appContents = user.getStocks();
			a_request.setAttribute("contents", appContents);
			a_request.setAttribute("user", user);
			jspPage = "/configureapps.jsp?op=addstock";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
