package com.polycom.sampleapps.servlet.stocks;


import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Vector;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultClientIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.protocol.BufferingHttpClientHandler;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.SessionRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;

/**
*
* <p>Title: NHttpClient</p>
*
* <p>Description: The class uses apache NIO to update the stocks content for given stock symbol
* It create sockets for every stock symbol ,connects to the url given,gets the data from site and updates the stocks information and chart information.
* </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class NHttpClient {

	private static final String STOCK_QUOTE_PROVIDER = "finance.yahoo.com";
	private static final String STOCK_CHART_PROVIDER = "ichart.yahoo.com";
	private static final String STOCK_QUOTE_URI = "/q?s=";
	private static final String STOCK_CHART_URI = "/t?s=";

	private static Hashtable<String, String> htStockFiles = new Hashtable<String, String>();
	private static Hashtable<String, String> htStockQuotes = new Hashtable<String, String>();
	private static Hashtable<String, byte[]> htStockCharts = new Hashtable<String, byte[]>();

	private Vector<String> m_stockSymbols;

	StockBmpConverter m_sbc;
	private DefaultConnectingIOReactor ioReactor;

	public NHttpClient(Vector<String> stockSymbols, StockBmpConverter sbc)
	{
		m_sbc = sbc;
		m_stockSymbols = stockSymbols;
		htStockFiles.clear();
		htStockQuotes.clear();
		htStockCharts.clear();
		final HttpParams params = new BasicHttpParams(null);
		params
				.setIntParameter(HttpConnectionParams.SO_TIMEOUT, 50000)
				.setIntParameter(HttpConnectionParams.CONNECTION_TIMEOUT, 70000)
				.setIntParameter(HttpConnectionParams.SOCKET_BUFFER_SIZE,
						8 * 1024).setBooleanParameter(
						HttpConnectionParams.STALE_CONNECTION_CHECK, false)
				.setBooleanParameter(HttpConnectionParams.TCP_NODELAY, true)
				.setParameter(HttpProtocolParams.USER_AGENT,
						"Jakarta-HttpComponents-NIO/1.1");

		try
		{
			ioReactor = new DefaultConnectingIOReactor(2, params);
			BasicHttpProcessor httpproc = new BasicHttpProcessor();
			httpproc.addInterceptor(new RequestContent());
			httpproc.addInterceptor(new RequestTargetHost());
			httpproc.addInterceptor(new RequestConnControl());
			httpproc.addInterceptor(new RequestUserAgent());
			httpproc.addInterceptor(new RequestExpectContinue());
	
			BufferingHttpClientHandler handler = new BufferingHttpClientHandler(
					httpproc, new MyHttpRequestExecutionHandler(),
					new NoConnectionReuseStrategy(), params);
	
	
			final IOEventDispatch ioEventDispatch = new DefaultClientIOEventDispatch(
					handler, params);
			
			//Initializes the NIO process to select the socket channels 
			Thread t = new Thread(new Runnable() {
				public void run() {
					try {
						ioReactor.execute(ioEventDispatch);
					} catch (InterruptedIOException ex) {
						//System.err.println("Interrupted");
					} catch (IOException e) {
						//System.err.println("I/O error: " + e.getMessage());
					}
				}
			});
			t.start();
	
			SessionRequest[] reqs = new SessionRequest[2 * m_stockSymbols.size()];
			int counter = 0;
			for (String symbol : m_stockSymbols) {
				SymbolKey quoteKey = new SymbolKey(STOCK_QUOTE_URI + symbol,
						new HttpHost(STOCK_QUOTE_PROVIDER));
				SymbolKey chartKey = new SymbolKey(STOCK_CHART_URI + symbol,
						new HttpHost(STOCK_QUOTE_PROVIDER));
	
				reqs[counter++] = ioReactor.connect(new InetSocketAddress(
						STOCK_QUOTE_PROVIDER, 80), null, quoteKey, null);
				reqs[counter++] = ioReactor.connect(new InetSocketAddress(
						STOCK_CHART_PROVIDER, 80), null, chartKey, null);
			}
		} catch (Exception e) {
		}
	}
	
	
	/**
	 * Closes all the opened socket channel
	 *
	 */
	public void shutDownClient()
	{
		try {
			if (ioReactor != null)
				ioReactor.shutdown();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Description:Used to initialize the connection,submitting the request and handling the response.
	 * The data obtained in response is updated in stock quote map/stock chart map for creating stock info objects
	 * @author smarella
	 *
	 */
	class MyHttpRequestExecutionHandler implements
			HttpRequestExecutionHandler {

		public void initalizeContext(final HttpContext context,
				final Object attachment) {
			SymbolKey chartKey = (SymbolKey) attachment;
			context.setAttribute("URI", chartKey.getURI());
			context.setAttribute(HttpExecutionContext.HTTP_TARGET_HOST,
					chartKey.getHttpHost());
		}

		public HttpRequest submitRequest(final HttpContext context) {
			
			String uri = (String) context.getAttribute("URI");
			BasicHttpRequest req = new BasicHttpRequest("GET", uri);
			
			return req;
		}

		/**
		 * If the response is related to html data then it is updated in quote table other wise chart table will be upadated
		 */
		public void handleResponse(final HttpResponse response,
				final HttpContext context) {
			HttpEntity entity = response.getEntity();

			String uri = (String) context.getAttribute("URI");
			if (uri != null) {
				try {
					String symbol = getSymbol(uri);
					if(m_sbc!=null)
					{	if (isStockQuote(uri)) 
						{
							m_sbc.getQuoteTable().put(symbol, EntityUtils.toString(entity));
						} else // stock chart
						{
							m_sbc.getChartTable().put(symbol, EntityUtils.toByteArray(entity));
						}
					}
				} catch (IOException ex) {
					//System.err.println("I/O error: " + ex.getMessage());
				}
				
			}
		}

		private String getSymbol(String aUri) {
			String result = null;
			result = aUri.substring(5);
			return result;
		}

		private boolean isStockQuote(String aUri) {
			boolean result = false;
			result = aUri.startsWith(STOCK_QUOTE_URI);
			return result;
		}
	}
	
	public static Hashtable<String, String> getHtStockFiles() {
		return htStockFiles;
	}

	public static Hashtable<String, String> getHtStockQuotes() {
		return htStockQuotes;
	}

	public static Hashtable<String, byte[]> getHtStockCharts() {
		return htStockCharts;
	}
}