package com.polycom.sampleapps.servlet.stocks;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;

import javax.imageio.ImageIO;

import com.polycom.sampleapps.servlet.common.ApplicationContext;

/**
*
* <p>Title: NHttpClient</p>
*
* <p>Description: The class created stock bmp images and stores the information of the stocks in stock info.
* It has utility methods for creating bmp images
* The data is updated using NHTTP Client and for every 5 min it will create stock  info
* </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/

public class StockBmpConverter extends Thread
{
	private static final int POLL_PERIOD = 5*60*1000; // 5 mins
	private StockManager m_manager;
	public static int stocksCreated = 1;
	//StockResponseThread m_respThread;
	Hashtable<String, byte[]> stockChartDataHt;//Key-> StockSymbol, Value-> Chart byte information
	Hashtable<String, String> stockSymbolDataHt;// Key-> Stock Symbol , Value-> Stockinformation	
	
	public StockBmpConverter(StockManager mgr)//StockResponseThread respThread, StockManager mgr)
	{
		//m_respThread = respThread;
		m_manager = mgr;
		stockChartDataHt = new Hashtable<String, byte[]>();
		stockSymbolDataHt = new Hashtable<String, String>();
	}
	
	public Hashtable<String, byte[]> getChartTable()
	{
		return stockChartDataHt;
	}
	
	public Hashtable<String, String> getQuoteTable()
	{
		return stockSymbolDataHt;
	}
	
	/*public void setStockChartAndQuoteData(Hashtable<String, byte[]> chartData, Hashtable<String, String> quoteData)
	{
		stockChartDataHt = chartData;
		stockSymbolDataHt = quoteData;	
		System.out.println("Charts count:"+stockChartDataHt.size());
		System.out.println("Quotes count:"+stockSymbolDataHt.size());
	}*/
	
	public void run()
	{
		while(true)
		{
			try
			{
				this.sleep(POLL_PERIOD);
					createImages();
			}
			catch(Exception ex)
			{
				ApplicationContext.logger.log(Level.SEVERE,
				  "Error in converting stock BMP");
			}
		}
	}
	
	/**
	 * Gets all the stocks symbols and creates stockinfo for each symbol
	 *
	 */
	private void createImages()
	{
		//Hashtable<String, byte[]> stockChartDataHt = m_respThread.getStockChartDataMap();
		//Hashtable<String, String> stockSymbolDataHt = m_respThread.getStockSymbolDataMap();	
		Vector<String> activeSymbols = m_manager.getActiveSymbols();
				for (String stock : activeSymbols)
				{
					if (stockChartDataHt.containsKey(stock)
							&& stockSymbolDataHt.containsKey(stock))
					{
						try
						{
							String quoteHtml =  stockSymbolDataHt.get(stock);
							byte[] chartHtml =  stockChartDataHt.get(stock);
							//System.out.println("creating Stockimage:" + stock);
							StockInfo info = createBMP(stock, quoteHtml, chartHtml, m_manager.getStockBmpPath());	
							if(info!=null)
								m_manager.getStockInfoHt().put(stock, info);
						} catch (Exception e) {
							//e.printStackTrace();
							ApplicationContext.logger.log(Level.SEVERE,
							  "Error in converting stock BMP2");
						}
					}
				}
	}

	/**
	 * Parses the stock information and chart byte information and creates StockInfo object will be used by server to send response
	 * @param a_itemName
	 * @param quote
	 * @param chartBytes
	 * @param stockFolder
	 * @return
	 */
	public static StockInfo createBMP(String a_itemName, String quote, byte[] chartBytes,String stockFolder)
	{
		StockInfo stockInfo=null;
		if((quote != null ) && (chartBytes != null) && (chartBytes.length > 0))
		{
			try
			{
				StockQuoteHtmlParser quoteHtmlParser = new StockQuoteHtmlParser();
				quoteHtmlParser.readQuote(quote);
				if (quoteHtmlParser.getLastTrade().length() > 0)
				{
					// NOW READ BYTE CONTENT OF CHANGE IMAGE
					BufferedImage arrowBuffer = null;
					String arrowUrl = quoteHtmlParser.getChangeImage().trim();
					// CREATE STOCK INFO AND CACHE IT AGAINST ITEM
					if ( stocksCreated == 50000 )
					{
						stocksCreated = 1;
					}
					if (chartBytes != null && chartBytes.length > 0)
					{
						String bmpFileName = a_itemName + "_" + stocksCreated
								+ ".bmp";
						String filePath = stockFolder + File.separator
								+ bmpFileName;
						stockInfo = new StockInfo(a_itemName,
								quoteHtmlParser.getLastTrade(), quoteHtmlParser
										.getVolume(), quoteHtmlParser.getChange(),
								arrowUrl, bmpFileName);
					
						boolean isImageCreated = convertToBmp(stockInfo, chartBytes, arrowBuffer, filePath);
	
						// 2. PUT FILE NAME IN StockInfo.
						File file = new File(filePath);
						
						if (file.exists() && isImageCreated)
						{
							stocksCreated++;
							return stockInfo;
						}
					}
				}
			}
			catch(Exception e)
			{
				//System.out.println("Error in convert BMP ::"+e.toString());
				ApplicationContext.logger.log(Level.SEVERE,
				  "Error in creating image for stock");
			}
		}
		return stockInfo;
	}
		
	/**
	 * Converts and saves stock chart with lasttrade, change and volume
	 * inforamtion into a bmp file.
	 * 
	 * @param a_stockUrl
	 *            String
	 * @param a_dispText
	 *            String
	 * @param a_filePath
	 *            String
	 * @throws IOException
	 */
	public static boolean convertToBmp(StockInfo a_stockInfo, byte[] chartImage,
			BufferedImage arrowImage, String a_filePath) throws Exception {
		boolean isImageCreatedSuccesfuly=false;
		
		try {			
			if (a_stockInfo != null) {
				String itemName = a_stockInfo.getItemName();
				//System.out.println("Creating image for:" + itemName);
				BufferedImage stockImage = null;
				BufferedImage targetImage = null;
				int sWidth1 = 0;
				int sWidth2 = 0;
				int sWidth4 = 0;
				int sWidth5 = 0;

				// CREATE STOCK CHART IMAGE IF IT EXISTS
				byte[] chartImageBytes = chartImage; // a_stockInfo.getChartImage();
				if (chartImageBytes != null && chartImageBytes.length > 0) {
					stockImage = ImageIO.read(new ByteArrayInputStream(
							chartImageBytes));
				}
				if (stockImage.getHeight() > 0 && stockImage.getWidth() > 0) {
					// CREATE TARGET IMAGE WITH STOCK CHART IMAGE AND STOCK
					// QUOTE INFORMATION.
					targetImage = new BufferedImage(250,
							stockImage.getHeight() + 7, stockImage.getType());
					Graphics2D g = (Graphics2D) targetImage.getGraphics();
					g.setColor(Color.WHITE);
					g.fillRect(0, 0, 250, targetImage.getHeight());
					g.setColor(Color.BLACK);
					g.setFont(new Font("Arial", Font.PLAIN, 11));
					// FINDING WIDTHS FOR TRADE AND VOLUME FOR SPECIFIED FONT
					FontMetrics fm = g.getFontMetrics();
					sWidth1 = fm.stringWidth(itemName + " ");
					g.drawString(itemName + " ", 1, 91);

					g.setFont(new Font("Arial", Font.PLAIN, 9));
					fm = g.getFontMetrics();
					sWidth2 = fm.stringWidth("Trade:$"
							+ a_stockInfo.getLastTrade() + " ");
					g.drawString("Trade:$" + a_stockInfo.getLastTrade() + " ",
							sWidth1, 91);
					g.drawString("Volume:" + a_stockInfo.getVolume(),
							(sWidth1 + sWidth2), 91);
					if (arrowImage != null) {
						sWidth4 = arrowImage.getWidth();
					}
					sWidth5 = fm.stringWidth("Change:");
					g.drawString("Change:", sWidth1, 91 + 9);
					if (arrowImage != null) {
						if (a_stockInfo.getChangeImageUrl().indexOf("up_") != -1) {
							BufferedImage img4 = arrowImage.getSubimage(0, 0,
									arrowImage.getWidth(), 11);
							g.drawImage(img4, (sWidth1 + sWidth5), 90, null);
						} else {
							BufferedImage img4 = arrowImage.getSubimage(0, 6,
									arrowImage.getWidth(), arrowImage
											.getHeight() - 6);
							g.drawImage(img4, (sWidth1 + sWidth5), 93, null);
						}
					}
					g.drawString(a_stockInfo.getChange(),
							(sWidth1 + sWidth5 + sWidth4), 91 + 9);
					g.drawImage(stockImage, 0, -13, stockImage.getWidth(),
							stockImage.getHeight(), null);
					File file = new File(a_filePath);
					// SAVE THE BUFFERED IMAGE AS A BMP FILE TO A SPECIFIED
					// LOCATION WITH STOCK NAME NAME AS THE FILE NAME
					isImageCreatedSuccesfuly = ImageIO.write(targetImage, "bmp", file);
				}
			}
		} catch (Exception ex) {
			throw ex;
		}
		
		return isImageCreatedSuccesfuly;
	}
}
