package com.polycom.sampleapps.servlet.stocks;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;


/**
*
* <p>Title: StockDataProcessor</p>
*
* <p>Description: Updates the stocks content for every 15 min through socket channel using NHTTP client
* It also start the StockBmpConverter which uses the updated data for converting them into stockinfo objects</p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/

public class StockDataProcessor extends Thread {
	private StockManager m_stockMgr;

	// //// HTTP PARAMS /////
	public static final String CHART_HOST_ADDRESS = "ichart.yahoo.com";

	public static final String QUOTE_HOST_ADDRESS = "finance.yahoo.com";

	public static final String CHART_QUERY_STRING = "/t?s=";

	public static final String QUOTE_QUERY_STRING = "/q?s=";

	public static final String CHART_PREFIX = "CHART_";

	public static final String QUOTE_PREFIX = "QUOTE_";

	public static Charset charset = Charset.forName("ISO-8859-1");

	public static CharsetDecoder decoder = charset.newDecoder();

	public static CharsetEncoder encoder = charset.newEncoder();

	StockBmpConverter sbc;

	private NHttpClient client;


	public StockDataProcessor(StockManager manager) {
		m_stockMgr = manager;		
		sbc = new StockBmpConverter(m_stockMgr);
		sbc.start();
	}

	public void run() {
		// GET ALL ACTIVE SYMBOLS FROM MGR and check if is accesed in past 5 min or not.If yes then update only those stock symbols
		while (true) {
			Vector<String> symbols = m_stockMgr.getActiveSymbols();
			
			long currTime = System.currentTimeMillis();		
			Vector<String> temp=new Vector<String>();
			HashMap<String, Long> stockAccessMap = m_stockMgr.getStockAccessMap();
			for(String symbol:symbols)
			{
				if(stockAccessMap.containsKey(symbol)&&
						(currTime-stockAccessMap.get(symbol))>ApplicationContext.UNUSED_PERIOD)
				{
					//m_stockMgr.delete(symbol);
				}				
				else if(!stockAccessMap.containsKey(symbol))
				{
					//m_stockMgr.delete(symbol);
				}else
				{
					temp.add(symbol);
				}
			}
			//System.out.println("Original Stocks:"+symbols.size()+"----Stock Symbols size:" + temp.size());
			
			if(symbols.size()>0)
			{
				client = new NHttpClient(temp, sbc);
				//ApplicationContext.logger.log(Level.INFO, "Stocks updated at"+new Date());
				
			}
			
			try {
				this.sleep(Constants.STOCKS_REFRESH_RATE);
				if (client != null) {
					client.shutDownClient();
					client = null;
				}
			} catch (Exception e) {

			}
			
		}
	}
}