package com.polycom.sampleapps.servlet.stocks;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTML.Attribute;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

import com.polycom.sampleapps.servlet.common.ContentReader;

/**
 *
 * <p>Title: StockQuoteHtmlParser</p>
 *
 * <p>Description: This class handles HTML tag start and end while parsing the HTML content</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class StockQuoteHtmlParser extends HTMLEditorKit.ParserCallback
{
	boolean lastTradeTag = false;
	boolean lastTradeSpanTag = false;
	boolean volumeTag = false;
	boolean volumeSpanTag = false;
	boolean changeTag = false;
	boolean imgTag = false;
	int changeBcount = 0;
	private String lastTrade = "";
	private String change = "";
	private String volume = "";
	private String changeImg = "";

	/**
	 * Returns lasttrade value parsed from content
	 * @return String
	 */
	public String getLastTrade()
	{
		return lastTrade;
	}

	/**
	 * Returns change value parsed from content
	 * @return String
	 */
	public String getChange()
	{
		return change;
	}

	/**
	 * Returns volume value parsed from content
	 * @return String
	 */
	public String getVolume()
	{
		return volume;
	}

	public String getChangeImage()
	{
		return changeImg;
	}

	public void handleText(char[] data, int pos)
	{
		String temp = new String(data);
		if (temp.indexOf("Last Trade:") != -1)
		{
			lastTradeTag = true;
		}
		else if (temp.indexOf("Change:") != -1)
		{
			changeTag = true;
		}
		else if (temp.indexOf("Volume:") != -1)
		{
			volumeTag = true;
		}
		else if (lastTradeTag)
		{
			lastTrade = temp;
			lastTradeSpanTag = false;
			lastTradeTag = false;
		}
		else if (changeTag)
		{
			if (temp.trim().length() > 0)
			{
				change += temp;
				if (changeBcount == 2)
				{
					changeTag = false;
				}
			}
		}
		else if (volumeTag)
		{
			volume = temp;
			volumeSpanTag = false;
			volumeTag = false;
		}
	}

	public void handleComment(char[] data, int pos)
	{
	}

	public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos)
	{
		if (t.equals(HTML.Tag.SPAN))
		{
			if (lastTradeTag)
			{
				lastTradeSpanTag = true;
			}
			if (volumeTag)
			{
				volumeSpanTag = true;
			}
		}
		if (t.equals(HTML.Tag.B))
		{
			if (changeTag)
			{
				changeBcount++;
			}
		}
	}

	public void handleEndTag(HTML.Tag t, int pos)
	{
	}

	public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos)
	{
		if (changeTag && t.equals(HTML.Tag.IMG))
		{
			Enumeration enum1 = a.getAttributeNames();
			while (enum1.hasMoreElements())
			{
				Attribute attr = (Attribute) enum1.nextElement();
				String value = (String) a.getAttribute(attr);
				if (attr.toString().equalsIgnoreCase("src"))
				{
					changeImg = value;
					break;
				}
			}
		}
	}

	public void handleError(String errorMsg, int pos)
	{
	}

	/**
	 * Reads the content from the given URL and parses the content.
	 * @param a_url String
	 * @param a_timeout String
	 * @throws Exception
	 */
	public void readQuote(String quoteHtml) throws Exception
	{
		BufferedReader reader = null;
		try
		{
			String content = quoteHtml;
			HTMLEditorKit.Parser parser;
			parser = new ParserDelegator();
			reader = new BufferedReader(new InputStreamReader(new
				ByteArrayInputStream(content.getBytes())));
			parser.parse(reader, this, true);
		}
		catch (Exception e)
		{
			this.flush();
			if (reader != null)
			{
				reader.close();
				reader = null;
			}
			throw e;
		}
		finally
		{
			this.flush();
			if (reader != null)
			{
				reader.close();
				reader = null;
			}
		}
	}
}