package com.polycom.sampleapps.servlet.stocks;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.io.File;
import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.Reader;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.RunnableReader;
import com.polycom.sampleapps.servlet.common.ThreadInfo;
import com.polycom.sampleapps.servlet.exception.ItemNotRegisteredException;

public class StockQuoteRefreshManager implements RefreshManager
{
	private static int MINIMUM_THREAD_COUNT = 2500; // Maximum number of threads in the pool
	private static StockQuoteRefreshManager m_self;
	private Reader m_stockQuoteReader; // Reader to read the content from content provider site
	private ScheduledThreadPoolExecutor m_execuotorService; // Scheduled executor thread pool
	// Contains the stock symbol as key and ScheduledFuture of periodic excution thread as value.
	private Hashtable<String, ThreadInfo> m_scheduleTable;
	
	private List m_symbolsLt; // Holds current active stock symbols.
	private Hashtable m_symbolFilesHt; // Key = symbol & value = bmp file location

	private String m_stocksFilePath = "";

	private StockQuoteRefreshManager(ApplicationContext ac)
	{
		//m_stockQuoteReader = StockQuoteReader.getInstance(this);
		//m_scheduleTable = new Hashtable<String, ThreadInfo> ();
		//m_execuotorService = (ScheduledThreadPoolExecutor) Executors.
		//	newScheduledThreadPool(MINIMUM_THREAD_COUNT);
		m_stocksFilePath = ac.getStocksDirPath();
		m_symbolsLt = new ArrayList();
		m_symbolFilesHt = new Hashtable();
	}
	
	public static synchronized StockQuoteRefreshManager getInstance(ApplicationContext ac)
	{
		if (m_self == null)
		{
			m_self = new StockQuoteRefreshManager(ac);
		}
		return m_self;
	}

	public String getBmpFilePath()
	{
		return m_stocksFilePath;
	}

	/**
	 * Registers a Stock symbol with the cache and invokes a thread to read the content from content provider urls.
	 * When adding stock quote, register the stock symbol with cache as ADD_ITEM.
	 * When Users are logged into system, register all the enbled stock symbols with cache as IDLE_ITEM.
	 * @param a_itemName String
	 * @param a_resultType ResultType
	 * @return Object
	 */
	public Object register(String a_itemName)
	{
		// CREATE NEW THREAD TO READ THE STOCK CHART AND QUOTE
		/*if (!m_scheduleTable.containsKey(a_itemName))
		{
			//ApplicationContext.logger.log(Level.INFO, "Creating scheduler for Item : " +a_itemName);
			scheduleReadingStockQuoteInfo(a_itemName);
		}*/
		if(!m_symbolsLt.contains(a_itemName))
		{
			m_symbolsLt.add(a_itemName);
		}
		return null;
	}

	/**
	 * If returns the result, stock quote information is processed inside a thread and cached bmp file inside the images directory.
	 * Also, caches the Stock quote information inside the reader.
	 * If returns null, stock quote information is not yet processed.
	 * @param a_itemName String
	 * @param a_resultType ResultType
	 * @return Object
	 */
	public Object getResult(String a_itemName) throws
		ItemNotRegisteredException
	{
		String result = null; // stock bmp file
		if(a_itemName != null)
		{
			result = (String)m_symbolFilesHt.get(a_itemName);
		}		
		return result;
	}
	
	/*Object result = m_stockQuoteReader.getResult(a_itemName);
		if (result == null)
		{
			ThreadInfo thInfo = m_scheduleTable.get(a_itemName);
			if (thInfo != null)
			{
				ScheduledFuture future = thInfo.getFuture();
				if (future != null)
				{
					try
					{
						future.get(Constants.CONTENT_READ_RFRESH_RATE,
								   TimeUnit.MILLISECONDS);
						result = m_stockQuoteReader.getResult(a_itemName);
					}
					catch (TimeoutException ex1)
					{
					}
					catch (ExecutionException ex1)
					{
						unregister(a_itemName);
						register(a_itemName);
					}
					catch (InterruptedException ex1)
					{
						unregister(a_itemName);
						register(a_itemName);
					}
				}
				else
				{
					throw new ItemNotRegisteredException(a_itemName +
						" not registered");
				}
			}
			else
			{
				throw new ItemNotRegisteredException(a_itemName +
					" not registered");
			}
		}
		//System.out.println("In stock refreshe manager"+result);
		return result;
	}*/

	/**
	 * Unregisters the Stock symbol from cache and cancels the refreshing thread.
	 * @param a_itemName String
	 */
	public void unregister(String a_itemName)
	{
		if(m_symbolsLt.contains(a_itemName))
		{
			m_symbolsLt.remove(a_itemName);
			if(m_symbolFilesHt.contains(a_itemName))
			{
				m_symbolFilesHt.remove(a_itemName);
			}
		}
	}
		/*try
		{
			ApplicationContext.logger.log(Level.INFO,
										  "Unregistering Item : " + a_itemName);
			ThreadInfo thInfo = m_scheduleTable.get(a_itemName);
			if ( thInfo != null )
			{
				ScheduledFuture future = thInfo.getFuture();
				if (future != null && !future.isCancelled())
				{
					future.cancel(true);
				}
			}
			m_scheduleTable.remove(a_itemName);
			m_stockQuoteReader.deleteCache(a_itemName);
			m_execuotorService.purge();
		}
		catch (Exception ex)
		{
		}
	}*/

	/**
	 * Shutdowns/Cancels the tasks that are excuting.
	 */
	/*public void shutdown()
	{
		m_execuotorService.shutdown();
	}*/

	public boolean isItemExist(String a_itemName)
	{
		boolean result = false;
		if(m_symbolsLt.contains(a_itemName))
		{
			result = true;
		}
		return result;
	}
		/*if (m_scheduleTable.containsKey(a_itemName))
		{
			result = true;
		}
		return result;
	}*/

	public void interruptBlockedThreads()
	{
		Hashtable<String, ThreadInfo> temp = new Hashtable<String,
			ThreadInfo> ();
		temp.putAll(m_scheduleTable);
		Iterator it = temp.keySet().iterator();
		while (it.hasNext())
		{
			String itemName = (String) it.next();
			ThreadInfo thInfo = (ThreadInfo) temp.get(itemName);
			RunnableReader runnable = thInfo.getRunnable();
			if (runnable.releaseFromBlockedState())
			{
				try
				{
					unregister(runnable.getItemName());
					register(runnable.getItemName());
				}
				catch (Exception ex)
				{
				}
			}
		}
		deleteItems();
	}

	/**
	 * Create and Schedules stock quote thread with given refresh rate and updates stock quote bmp file.
	 * @param a_itemName String
	 */
	private void scheduleReadingStockQuoteInfo(String a_itemName)
	{
		RunnableReader runReader = new RunnableReader(m_stockQuoteReader,
			a_itemName, Constants.DEFAULT_STOCK_THREAD_TIMEOUT);
		ScheduledFuture future = m_execuotorService.scheduleWithFixedDelay(
			runReader, 0, Constants.DEFAULT_STOCK_CONTENT_READ_TIMEOUT,
			TimeUnit.MILLISECONDS);
		ThreadInfo thInfo = new ThreadInfo(runReader, future);
		m_scheduleTable.put(a_itemName, thInfo);
	}

	public void deleteItems()
	{
		// Get All Files
		File file = new File(m_stocksFilePath);
		File[] files = file.listFiles();
		for(File f: files)
		{
			long lastModified = f.lastModified();
			long currTime = System.currentTimeMillis();
			if((currTime - lastModified) > 10*60*1000)
			{
				f.delete();
			}
		}
	}

	public void shutdown() {
		// TODO Auto-generated method stub
		
	}
}
