package com.polycom.sampleapps.servlet.stocks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class StockRequestThread extends Thread {

	public static final String CHART_HOST_ADDRESS = "ichart.yahoo.com";
	public static final String QUOTE_HOST_ADDRESS = "finance.yahoo.com";
	public static final String CHART_QUERY_STRING = "/t?s=";
	public static final String QUOTE_QUERY_STRING = "/q?s=";
	
	private final int READOUT_PERIOD = 1000 * 60 * 1;
	private final int SELECT_READ_PERIOD = 1000 * 60;

	private Selector m_Selector;

	public StockRequestThread(Selector a_Selector) {
		m_Selector = a_Selector;
	}

	public void run() {
		
		while(true)
		{
			try
			{
				this.sleep(READOUT_PERIOD);
			}
			catch(Exception e)
			{
				
			}
			// Select the channels that are eligible for IO operations
			try {
				m_Selector.select(SELECT_READ_PERIOD);
			} catch (IOException e1) {
				e1.printStackTrace();
			}
	
			Set<?> readyKeys = m_Selector.selectedKeys();
	
			// If selected keys and the requested stocks are equal the send the
			// requests
			try {
				String QUERY_STRING = "";
				//System.out.println("Started sending requests for quotes");
				Iterator<?> readyItor = readyKeys.iterator();
				while (readyItor.hasNext()) {
					boolean isQuoteSymbol = true;
					SelectionKey selKey = (SelectionKey) readyItor.next();
					readyItor.remove();
					SocketChannel sChannel = (SocketChannel) selKey.channel();
					String attachment = (String) selKey.attachment();
					String Symbol = null;
					int prefixIndex = attachment
							.indexOf(StockDataProcessor.QUOTE_PREFIX);
					if (prefixIndex == -1) {
						isQuoteSymbol = false;
						prefixIndex = attachment
								.indexOf(StockDataProcessor.CHART_PREFIX);
					}
					Symbol = attachment.substring(prefixIndex);
					//System.out.println("In stock *********** req thread........"+Symbol);
					if (selKey.isConnectable()) {
						//if (sChannel.isConnectionPending())
						{
							boolean success = sChannel.finishConnect();
							if (!success) {
								selKey.cancel();
							}
						}
						//System.out.println("check-----------------1");
						String request = "GET " + QUERY_STRING + Symbol
								+ " \r\n\r\n";
						if (isQuoteSymbol)
							sChannel.write(StockDataProcessor.encoder
									.encode(CharBuffer.wrap(request)));
						else
							sChannel.write(ByteBuffer.wrap(request.getBytes()));
						//System.out.println("check-----------------2");
						//Sets the channel to read mode
						sChannel.register(m_Selector, SelectionKey.OP_READ);
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
	}
		
	}
}
