package com.polycom.sampleapps.servlet.stocks;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StockResponseThread extends Thread {

	private final int READOUT_PERIOD = 1000 * 60 * 1;
	private final int SELECT_READ_PERIOD = 1000 * 60;
	private Selector m_Selector;

	Hashtable<String, String> stockSymbolDataMap = new Hashtable<String, String>();
	Hashtable<String, byte[]> stockChartDataMap = new Hashtable<String, byte[]>();

	public StockResponseThread(Selector a_Selector) {
		m_Selector = a_Selector;
	}

	public void run() {
		while(true)
		{
			try {
				this.sleep(READOUT_PERIOD);
			} catch (InterruptedException e2) {
				e2.printStackTrace();
			}
	
			// Select the channels that are eligible for IO operations
	
			try {
				m_Selector.select(SELECT_READ_PERIOD);
			} catch (IOException e1) {
				e1.printStackTrace();
			}
	
			Set<?> readyKeys = m_Selector.selectedKeys();
	
			// If selected keys and the requested stocks are equal the send the
			// requests
			try {
				System.out.println("Started sending response for quotes");
				Iterator<?> readyItor = readyKeys.iterator();
				while (readyItor.hasNext()) {
					boolean isQuoteSymbol = false;
					SelectionKey selKey = (SelectionKey) readyItor.next();
					readyItor.remove();
					SocketChannel sChannel = (SocketChannel) selKey.channel();
					String attachment = (String) selKey.attachment();
					String Symbol = null;
					int prefixIndex = attachment
							.indexOf(StockDataProcessor.QUOTE_PREFIX);
					if (prefixIndex == -1) {
						isQuoteSymbol = true;
						prefixIndex = attachment
								.indexOf(StockDataProcessor.CHART_PREFIX);
					}
					Symbol = attachment.substring(prefixIndex);
					System.out.println("In stock response thread........"+Symbol);
					// //////////////////
					if (selKey.isValid() && selKey.isReadable()) {
						System.out.println("check-----------------123");
						ByteBuffer buffer = ByteBuffer.allocateDirect(1024 * 16);
						CharBuffer charBuffer = CharBuffer.allocate(1024 * 16);
	
						if (!isQuoteSymbol) {
							StringBuffer result = new StringBuffer();
							byte[] bytes = null;
							while ((sChannel.read(buffer)) != -1) {
								buffer.flip();
								bytes = new byte[buffer.limit()];
								for (int i = 0; i < buffer.limit(); i++) {
									bytes[i] = buffer.get(i);
								}
								charBuffer.flip();
								CharBuffer asCharBuffer = buffer.asCharBuffer();
								result.append(asCharBuffer.subSequence(0,
										asCharBuffer.length()).toString());
								buffer.clear();
								charBuffer.clear();
							}
							if (bytes != null) {
								stockChartDataMap.put(Symbol, bytes);
							}
						} else {
							StringBuffer result = new StringBuffer();
							while ((sChannel.read(buffer)) != -1) {
								buffer.flip();
								StockDataProcessor.decoder.decode(buffer,
										charBuffer, false).toString();
								charBuffer.flip();
								result.append(charBuffer);
								buffer.clear();
								charBuffer.clear();
							}
							if (!result.equals("")) {
								stockSymbolDataMap.put(Symbol, result.toString());
	
							}
						}
						System.out.println("cehck---------------456");
						sChannel.close();
					}
				}
	
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public Hashtable<String, String> getStockSymbolDataMap() {
		return stockSymbolDataMap;
	}

	public Hashtable<String, byte[]> getStockChartDataMap() {
		return stockChartDataMap;
	}

}
