package com.polycom.sampleapps.servlet.stocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.Stock;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: ViewQuotesServlet</p>
 *
 * <p>Description: This servlet fetches quote for configured stocks and displays it on a screen for User</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ViewQuotesServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from viewstocks.jsp to display configured stock quotes for users.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to view stock quotes.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			List<Stock> dispQuotes = new ArrayList<Stock> ();
			Vector<Item> stocks = user.getStocks();
			for (Item stock : stocks)
			{
				//RefreshManager manager = appContext.getStockRefreshManager();
				StockManager stockManager = appContext.getStockManager();
				//boolean isExist = manager.isItemExist(stock.getName());
				boolean isExist = stockManager.isSymbolExists(stock.getName());
				if (!isExist)
				{
					//manager.register(stock.getName());
					stockManager.add(stock.getName());
				}
				try
				{
					//StockInfo stockInfo = (StockInfo) manager.getResult(stock.getName());
					StockInfo stockInfo = stockManager.getStockInfo(stock.getName());
					Stock dispQuote = new Stock(stock.getName(),
												stockInfo.getLastTrade(),
												stockInfo.getVolume(),
												stockInfo.getChange());
					dispQuotes.add(dispQuote);
				}
				catch (Exception ex)
				{
				}
			}
			a_request.setAttribute("quotes", dispQuotes);
			jspPage = "/viewstockquotes.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
