package com.polycom.sampleapps.servlet.stocks;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;

/**
 *
 * <p>Title: ViewStockServlet</p>
 *
 * <p>Description: This servlet displays selected stock chart for users.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ViewStockServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from viewstocks.jsp to display selected stock chart for users.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to view stock chart.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			Vector<Item> stocks = user.getStocks();
			String stockName = (String) a_request.getParameter("stockname");
			Item stock = null;
			for (Item cApp : stocks)
			{
				if (cApp.getName().equals(stockName))
				{
					stock = cApp;
					break;
				}
			}
			boolean bmpConvert = true;
			if (stock != null)
			{
				Application app = user.getStockApplication();
				Item lastViewedStock = app.getLastViewedStock();
				if (lastViewedStock != null)
				{
					// DISPLAY STOCK AS PER SELECTED STOCKNAME
					Item tempApp = stocks.get(0);
					user.getStocks().remove(0);
					stocks = user.getStocks();
					// ADDING DISPLAYED STOCK IN LAST POSITION
					int index = 0;
					for (Item cApp : stocks)
					{
						if (cApp.isAddedToHomePage())
						{
							// do nothing
						}
						else
						{
							break;
						}
						index++;
					}
					user.getStocks().add(index, tempApp);
				}
				app.setLastViewedStock(stock);
				//int index = user.getStocks().indexOf(stock);
				// REMOVING DISPLAY STOCK FROM STOCKS
				Iterator it = stocks.iterator();
				while (it.hasNext())
				{
					Item tempStock = (Item) it.next();
					if (tempStock.getName().equals(stock.getName()))
					{
						it.remove();
						break;
					}
				}
				// ADDING DISPLAY STOCK AT ZERO POSITION
				user.getStocks().add(0, stock);
				// PERSIST USER
				try
				{
					String userFilePath = appContext.getXmlDirPath() +
						user.getName() + ".xml";
					PersistUser.persist(user, userFilePath);
				}
				catch (IOException ex1)
				{
					ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
												  ex1);
				}
			}
			if (bmpConvert)
			{
				a_request.setAttribute("stock", stock);
				a_request.setAttribute("stocks", user.getStocks());
			}
			else
			{
				a_request.setAttribute("stock", stock);
				a_request.setAttribute("stocks", user.getStocks());
				errorMessage = stock.getName() + " chart not available";
				a_request.setAttribute("errormessage", errorMessage);
			}
			jspPage = "/viewstocks.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
