package com.polycom.sampleapps.servlet.stocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

/**
 *
 * <p>Title: ViewStocksServlet</p>
 *
 * <p>Description: This servlet displays configured stocks for users.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author T Ravikanth
 * @version 1.0
 */
public class ViewStocksServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from applications.jsp to display configured stocks for users.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to view stocks page.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			Vector<Item> stocks = user.getStocks();
			String stockName = (String) a_request.getParameter("stockname");
			List<Item> dispStocks = new ArrayList<Item> ();
			Item stock = null;
			if (stockName == null)
			{
				// DISPLAY FIRST STOCK
				if (stocks.size() > 0)
				{
					stock = stocks.get(0);
					dispStocks.addAll(stocks);
				}
				else
				{
					errorMessage = "Stocks not configured.";
					a_request.setAttribute("message", errorMessage);
				}
			}
			else
			{
				stock = stocks.get(0);
				dispStocks.addAll(stocks);
			}
			a_request.setAttribute("stocks", dispStocks);
			a_request.setAttribute("stock", stock);
			a_request.setAttribute("stockbmpfile", "");
			jspPage = "/viewstocks.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
