package com.polycom.sampleapps.servlet.test;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import com.polycom.sampleapps.servlet.common.data.Application;
import com.polycom.sampleapps.servlet.common.data.Item;
import com.polycom.sampleapps.servlet.common.data.User;
import com.polycom.sampleapps.servlet.common.data.UserProfile;

public class ProfileCreator
{
	String winStock = "D:\\Polycom\\Sample Applications\\WORKINGQUOTES.txt";
	String winWeather = "D:\\Polycom\\Sample Applications\\WORKINGWEATHER.txt";
	String winNews = "D:\\Polycom\\Sample Applications\\WORKINGNEWS.txt";

	String linuxStock = "//home//akumar//WORKINGQUOTES.txt";
	String linuxWeather = "//home//akumar//WORKINGWEATHER.txt";
	String linuxNews = "//home//akumar//WORKINGNEWS.txt";

	private int totalProfiles = 200;
	List<String> stocks;
	List<String> weather;
	List<String> news;

	int symbols = 4;
	int locs = 2;
	int rss = 1;

	int symbolsCount = 0;
	int locsCount = 0;
	int rssCount = 0;

	public ProfileCreator()
	{
		readStocks();
		readWeahter();
		readNews();
	}

	public List<UserProfile> createProfiles()
	{
		List<UserProfile> temp = new ArrayList<UserProfile> ();
		System.out.println("Stocks : " + stocks.size());
		System.out.println("Weather : " + weather.size());
		System.out.println("News : " + news.size());
		for (int i = 0; i < totalProfiles; i++)
		{
			UserProfile profile = new UserProfile();
			User user = new User("" + (i + 2), "pass", "END_USER");
			profile.setUser(user);
			Application stockapp = new Application("1", "Stocks",
				"/viewstocks", "4", "true", "10");
			Vector<Item> items = new Vector<Item> ();
			for (int j = 0; j < symbols; j++)
			{
				String symbol = stocks.get(symbolsCount);
				Item item = new Item(symbol, "", "true");
				items.add(item);
				symbolsCount++;
			}
			stockapp.setItems(items);

			Application locapp = new Application("2", "Weather",
												 "/viewlocations", "2", "true",
												 "10");
			items = new Vector<Item> ();
			for (int j = 0; j < locs; j++)
			{
				String symbol = weather.get(locsCount);
				Item item = new Item(symbol, "", "true");
				items.add(item);
				locsCount++;
				if (locsCount == weather.size())
				{
					locsCount = 0;
				}
			}
			locapp.setItems(items);

			Application newsapp = new Application("3", "News",
												  "/viewnews", "1", "true",
												  "10");
			items = new Vector<Item> ();
			for (int j = 0; j < rss; j++)
			{
				String symbol = news.get(rssCount);
				Item item = new Item(symbol, symbol, "true");
				items.add(item);
				rssCount++;
				if (rssCount == news.size())
				{
					rssCount = 0;
				}
			}
			newsapp.setItems(items);
			Vector<Application> apps = new Vector<Application> ();
			apps.add(stockapp);
			apps.add(locapp);
			apps.add(newsapp);
			Application thoughtApp = new Application("4", "Thought Of The Day",
				"/viewtftd", "1", "true", "10");
			apps.add(thoughtApp);
			profile.setApplications(apps);
			temp.add(profile);
		}
		return temp;
	}

	private void readStocks()
	{
		stocks = new ArrayList<String> ();
		try
		{
			BufferedReader stock = new BufferedReader(new FileReader(winStock));
			int counter = 0;
			String line = null;
			while ( (line = stock.readLine()) != null)
			{
				stocks.add(line.trim());
			}
		}
		catch (Exception ex)
		{
		}
	}

	private void readWeahter()
	{
		weather = new ArrayList<String> ();
		try
		{
			BufferedReader loc = new BufferedReader(new FileReader(winWeather));
			int counter = 0;
			String line = null;
			while ( (line = loc.readLine()) != null)
			{
				weather.add(line.trim());
			}
		}
		catch (Exception ex)
		{
		}
	}

	private void readNews()
	{
		news = new ArrayList<String> ();
		try
		{
			BufferedReader loc = new BufferedReader(new FileReader(winNews));
			int counter = 0;
			String line = null;
			while ( (line = loc.readLine()) != null)
			{
				news.add(line.trim());
			}
		}
		catch (Exception ex)
		{
		}
	}

	public static void main(String[] argss)
	{
		ProfileCreator pc = new ProfileCreator();
		pc.createProfiles();
	}
}
