package com.polycom.sampleapps.servlet.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class Simulator
{
	String COOKIE = "Set-Cookie";
	String USER_NAME_COOKIE = "username";
	String APPLICATION_COOKIE = "APPLICATION";
	String CONTENT_COOKIE = "CONTENT";
	String NEWS_INDEX_COOKIE = "NEWS_DISPLAYED_INDEX";
	String NEWS_STRING_COOKIE = "NEWS_DISPLAYED_STRING";
	String PREVIOUS_REFRESH_PERIOD_COOKIE = "PREVIOUS_REFRESH_PERIOD";
	int REFRESH_RATE = 15 * 1000;
	int totalCount = 0;

	public Simulator()
	{
		int size = 5;
		for (int i = 0; i < size; i++)
		{
			Thread th = new Thread(new Counter( (i + 2)));
			th.start();
		}
	}

	public static void main(String[] args)
	{
		Simulator simulator = new Simulator();
	}

	public synchronized void count(boolean flag)
	{
		if (flag)
		{
			totalCount++;
		}
		else
		{
			totalCount--;
		}
		System.out.println("Thread Count*********************** " + totalCount);
	}

	class Counter implements Runnable
	{
		Connector previous = null;
		int m_user;

		public Counter(int a_user)
		{
			m_user = a_user;
		}

		public void run()
		{
			while (true)
			{
				Connector conn = new Connector(m_user);
				if (previous != null)
				{
					if (previous.appCookie != null)
					{
						conn.appCookie = previous.appCookie;
						conn.contentCookie = previous.contentCookie;
						conn.newsIndexCookie = previous.newsIndexCookie;
						conn.newsStringCookie = previous.newsStringCookie;
					}
				}
				Thread th = new Thread(conn);
				th.start();
				//count(true);
				try
				{
					Thread.currentThread().sleep(REFRESH_RATE);
					previous = conn;
				}
				catch (InterruptedException ex)
				{
				}
			}
		}
	}

	class Connector implements Runnable
	{
		String appCookie;
		String contentCookie;
		String newsIndexCookie;
		String newsStringCookie;
		int m_user;

		public Connector(int a_user)
		{
			m_user = a_user;
		}

		public void run()
		{
			try
			{
				System.out.println("Start Request***********");
				URL url = new URL(
					"http://10.11.32.128:8080/sampleapps/idle");
				HttpURLConnection conn = (HttpURLConnection) url.openConnection();
				if (appCookie != null)
				{
					conn.setRequestProperty("Set-Cookie1", appCookie);
					conn.setRequestProperty("Set-Cookie2", contentCookie);
					conn.setRequestProperty("Set-Cookie3", newsIndexCookie);
					conn.setRequestProperty("Set-Cookie4", newsStringCookie);
				}
				conn.setRequestProperty("Set-Cookie5", "username=" + m_user);
				InputStream is = conn.getInputStream();
				for (int i = 0; i < 20; i++)
				{
					String key = conn.getHeaderFieldKey(i + 1);
					if (key != null && key.equals(COOKIE))
					{
						String value = conn.getHeaderField(i + 1);
						//System.out.println(key + "  : COOKIE :  " + value);
						if (value.startsWith(APPLICATION_COOKIE))
						{
							appCookie = value;
						}
						else if (value.startsWith(CONTENT_COOKIE))
						{
							contentCookie = value;
						}
						else if (value.startsWith(NEWS_INDEX_COOKIE))
						{
							newsIndexCookie = value;
						}
						else if (value.startsWith(NEWS_STRING_COOKIE))
						{
							newsStringCookie = value;
						}
					}
				}
				byte[] buff = new byte[1024];
				while (is.read(buff) != -1)
				{
					buff = new byte[1024];
				}
				is.close();
				conn.disconnect();
				System.out.println("End Response*********" + contentCookie);
				//count(false);
			}
			catch (MalformedURLException ex)
			{
			}
			catch (IOException ex)
			{
			}
		}
	}
}
