package com.polycom.sampleapps.servlet.thought;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

import com.polycom.sampleapps.servlet.common.ContentReader;

/**
 *
 * <p>Title: QuoteHtmlParser</p>
 *
 * <p>Description: This class handles HTML tag start and end while parsing the HTML content</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Ravikanth T
 * @version 1.0
 */
public class QuoteHtmlParser extends HTMLEditorKit.ParserCallback
{
	//
	private boolean dlTag;
	private boolean dtTag;
	private boolean ddTag;
	private int aTagCount = 0;
	private List<String> m_quoteList;
	private String m_quote;

	public QuoteHtmlParser()
	{
		m_quoteList = new ArrayList<String> ();
	}

	/**
	 * Returns the parsed quotes
	 * @return List
	 */
	public List getQuoteList()
	{
		return m_quoteList;
	}

	public void handleText(char[] data, int pos)
	{
		if (dlTag)
		{
			if (dtTag && aTagCount == 1)
			{
				m_quote = new String(data);
				if (m_quote.length() < 180)
				{
					// accept
				}
				else
				{
					m_quote = "";
				}
			}
			else if (ddTag && aTagCount == 4)
			{
				if (m_quote.length() > 0)
				{
					int lines = m_quote.length() / 35; // 35 is max number of characters can be displayed in the screen in a line
					if (lines <= 4)
					{
						m_quote += "<br/>" + new String(data);
						//System.out.println("Quote : " + m_quote);
						m_quoteList.add(m_quote);
					}
					else if (lines == 5)
					{
						m_quoteList.add(m_quote);
					}
					m_quote = "";
				}
			}
		}
	}

	public void handleComment(char[] data, int pos)
	{
	}

	public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos)
	{
		if (t == HTML.Tag.DL)
		{
			dlTag = true;
		}
		else if (t == HTML.Tag.DT)
		{
			dtTag = true;
		}
		else if (t == HTML.Tag.DD)
		{
			ddTag = true;
		}
		else if (t == HTML.Tag.A)
		{
			if (dtTag || ddTag)
			{
				aTagCount++;
			}
		}
	}

	public void handleEndTag(HTML.Tag t, int pos)
	{
		if (t.equals(HTML.Tag.DL))
		{
			dlTag = false;
		}
		else if (t == HTML.Tag.DT)
		{
			dtTag = false;
			aTagCount = 0;
		}
		else if (t == HTML.Tag.DD)
		{
			ddTag = false;
			aTagCount = 0;
			if (m_quote != null && m_quote.length() > 0)
			{
				if (m_quote.length() < 180)
				{
					m_quoteList.add(m_quote);
				}
			}
			m_quote = "";
		}
		else if (t == HTML.Tag.A)
		{
			if (ddTag && aTagCount == 4)
			{
				aTagCount = 0;
			}
		}
	}

	public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos)
	{
		if (t == HTML.Tag.DL)
		{
			dlTag = true;
		}
		else if (t == HTML.Tag.DT)
		{
			dtTag = true;
		}
		else if (t == HTML.Tag.DD)
		{
			ddTag = true;
		}
		else if (t == HTML.Tag.A)
		{
			if (dtTag || ddTag)
			{
				aTagCount++;
			}
		}
	}

	public void handleError(String errorMsg, int pos)
	{
	}

	/**
	 * Reads and parses Quote content
	 * @param a_url String
	 * @param a_timeout String
	 * @throws Exception
	 */
	public void readThought(String a_url) throws
		Exception
	{
		BufferedReader reader = null;
		try
		{
			String content = a_url;
			HTMLEditorKit.Parser parser;
			parser = new ParserDelegator();
			reader = new BufferedReader(new InputStreamReader(new
				ByteArrayInputStream(content.getBytes())));
			parser.parse(reader, this, true);
		}
		catch (Exception e)
		{
			this.flush();
			if (reader != null)
			{
				reader.close();
			}
			throw e;
		}
		finally
		{
			this.flush();
			if (reader != null)
			{
				reader.close();
			}
		}
	}

	public static void main(String[] args)
	{
		try
		{
			QuoteHtmlParser parser = new QuoteHtmlParser();
			//parser.readThought("http://www.quotationspage.com/qotd.html", "0");
		}
		catch (Exception ex)
		{
		}
	}
}
