package com.polycom.sampleapps.servlet.thought;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.stocks.StockDataProcessor;


/**
*
* <p>Title: ThoughtForTheDayDataProcessor</p>
*
* <p>Description: Updates the quotes information for every 24 hrs .If quotes are not available then it will try to get the quotes for every 60 min until it gets data </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class ThoughtForTheDayDataProcessor extends Thread {

	private static final String THOUGHT_OF_THE_DAY_URL = "http://www.quotationspage.com/qotd.html";

	private ThoughtForTheDayManager m_manager;

	public ThoughtForTheDayDataProcessor(ThoughtForTheDayManager manager) {
		m_manager = manager;
	}

	public void run() {
		while (true) {
			try {
				
				if (checkIfQuotesExists())
					this.sleep(Constants.TFTD_REFRESH_RATE);
				else
					this.sleep(1000 * 60 * 60);	
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Creates socket channel for quotes and gets the data from site when available and updates the quote information in manager
	 * @return
	 */
	public boolean checkIfQuotesExists() {
		URL url = null;
		try {
			url = new URL(THOUGHT_OF_THE_DAY_URL);
		} catch (MalformedURLException e1) {
			e1.printStackTrace();
		}
		String hostAddress = url.getHost();
		String uri = url.getPath();
		ByteBuffer buffer = ByteBuffer.allocateDirect(1024 * 16);
		CharBuffer charBuffer = CharBuffer.allocate(1024 * 16);
		try {
			SocketChannel sChannel = SocketChannel.open();
			sChannel.configureBlocking(false);
			sChannel.connect(new InetSocketAddress(hostAddress, 80));
			Selector selector = Selector.open();
			SelectionKey sKey = sChannel
					.register(selector, sChannel.validOps());
			selector.select();
			sChannel.finishConnect();
			String request = "GET " + uri + " \r\n\r\n";
			sChannel.write(StockDataProcessor.encoder.encode(CharBuffer
					.wrap(request)));
			sKey = sChannel.register(selector, SelectionKey.OP_READ);
			selector.select(30 * 1000);
			if (sKey.isReadable()) {
				try {
					StringBuffer buff = new StringBuffer();
					while ((sChannel.read(buffer)) != -1) {
						buffer.flip();
						StockDataProcessor.decoder.decode(buffer, charBuffer,
								false).toString();
						charBuffer.flip();
						buff.append(charBuffer);
						buffer.clear();
						charBuffer.clear();
					}
					QuoteHtmlParser quoteParser = new QuoteHtmlParser();
					quoteParser.readThought(buff.toString());
					List<String> quotes = quoteParser.getQuoteList();
					if (quotes.size() > 0)
					{
						m_manager.getActiveItems().removeAllElements();
						m_manager.getActiveItems().addAll(quotes);
						return true;
					}
					
				} catch (Exception e) {
				}
			}
			ApplicationContext.logger.log(Level.INFO, "Thought for the day updated at"+new Date());
		} catch (IOException e) {
			return false;
		}
		return false;
	}

}
