package com.polycom.sampleapps.servlet.thought;

import java.util.Calendar;
import java.util.Vector;


/**
*
* <p>Title: ThoughtForTheDayManager</p>
*
* <p>Description: Caches the thought for the day quotes and have utility methods to retrive the informtion
* If no thought for the day is configured it will show default quote </p>
*
* <p>Copyright:* Copyright (c) 2007 Polycom Canada Ltd.</p>
*
* <p>Company: Polycom, Inc</p>
*
* @author M Sandeep
* @version 1.0
*/
public class ThoughtForTheDayManager {

	private static ThoughtForTheDayManager m_self;
	private Vector<String> m_thoughtOfTheDayVector;
	private int m_date;
	private final String m_defaultThoughtOfTheDayText = "When men are pure, laws are useless; when men are corrupt, laws are broken.<br/>Benjamin Disraeli";
	private String m_currentDisplayingThoughtOfTheDayText;

	public ThoughtForTheDayManager() {
		m_thoughtOfTheDayVector = new Vector<String>();
		m_date = Calendar.getInstance().get(Calendar.DATE);
		m_currentDisplayingThoughtOfTheDayText = m_defaultThoughtOfTheDayText;
		initDataProcessor();
	}
	
	public static synchronized ThoughtForTheDayManager getInstannce()
	{
		if (m_self == null)
		{
			m_self = new ThoughtForTheDayManager();
		}
		return m_self;
	}

	/**
	 *Initializes the processor which will update the quotes information for every 24 hrs
	 *
	 */
	private void initDataProcessor() {
		ThoughtForTheDayDataProcessor processor=new ThoughtForTheDayDataProcessor(this);
		processor.start();
	}

	/**
	 * Adds new quote in currently cached quotes
	 * @param qoute
	 */
	public void add(String qoute) {
		if (!m_thoughtOfTheDayVector.contains(qoute)) {
			m_thoughtOfTheDayVector.add(qoute);
		}
	}

	/**
	 * Returns the quote message for phone. If nothing is there in current cache of quotes then default quote is returned
	 * @return
	 */
	public String getMessage() {

		try{
			if (m_thoughtOfTheDayVector.size() > 0)
			{
				return m_thoughtOfTheDayVector.get(0);
			}
		}catch(Exception e)
		{
			
		}

		return m_currentDisplayingThoughtOfTheDayText;
	}

	/**
	 * Deletes the quote from cache
	 * @param qoute
	 */
	public void delete(String qoute) {
		m_thoughtOfTheDayVector.remove(qoute);
	}

	public Vector<String> getActiveItems() {
		return m_thoughtOfTheDayVector;
	}

	/**
	 * Sets the default thought for the day with given message
	 * @param thoughtForTheDayMessage
	 */
	public void setMessage(String thoughtForTheDayMessage) {
		m_currentDisplayingThoughtOfTheDayText = thoughtForTheDayMessage;
	}

}
