package com.polycom.sampleapps.servlet.thought;

import java.util.Calendar;
import java.util.List;
import java.util.Vector;

import com.polycom.sampleapps.servlet.common.Reader;

public class ThoughtOfTheDayReader implements Reader
{
	private static final String THOUGHT_OF_THE_DAY_URL =
		"http://www.quotationspage.com/qotd.html";
	private static ThoughtOfTheDayReader m_self;
	private Vector<String> m_thoughtOfTheDayVector;
	private final String m_defaultThoughtOfTheDayText = "When men are pure, laws are useless; when men are corrupt, laws are broken.<br/>Benjamin Disraeli";
	private String m_currentDisplayingThoughtOfTheDayText;
	private int m_date;

	private ThoughtOfTheDayReader()
	{
		m_thoughtOfTheDayVector = new Vector<String> ();
		m_date = Calendar.getInstance().get(Calendar.DATE);
		m_currentDisplayingThoughtOfTheDayText = m_defaultThoughtOfTheDayText;
	}

	public static ThoughtOfTheDayReader getInstance()
	{
		if (m_self == null)
		{
			m_self = new ThoughtOfTheDayReader();
		}
		return m_self;
	}

	public Object read(String a_itemName)
	{
		while ( true )
		{
			try
			{
				QuoteHtmlParser quoteParser = new QuoteHtmlParser();
				//quoteParser.readThought(THOUGHT_OF_THE_DAY_URL, "");
				List<String> quotes = quoteParser.getQuoteList();
				m_thoughtOfTheDayVector.addAll(quotes);
				break;
			}
			catch (Exception ex)
			{
			}
		}
		return "";
	}

	public Object getResult(String a_itemName)
	{
		String result = m_currentDisplayingThoughtOfTheDayText;
		int size = m_thoughtOfTheDayVector.size();
		int currDate = Calendar.getInstance().get(Calendar.DATE);
		if (m_date != currDate)
		{
			if (size > 0)
			{
				result = m_thoughtOfTheDayVector.get(0);
				m_thoughtOfTheDayVector.remove(0);
				m_currentDisplayingThoughtOfTheDayText = result;
			}
			m_date = currDate;
		}
		return result;
	}

	public void deleteCache(String a_itemName)
	{
	}
}
