package com.polycom.sampleapps.servlet.thought;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

import com.polycom.sampleapps.servlet.common.Reader;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.RunnableReader;
import com.polycom.sampleapps.servlet.common.Constants;

public class ThoughtRefreshManager implements RefreshManager
{
	private static int MINIMUM_THREAD_COUNT = 1;
	private static ThoughtRefreshManager m_self;
	private Reader m_thoughtOfTheDayReader;
	private boolean m_isRegistered;
	private ScheduledExecutorService m_execuotorService;
	private ScheduledFuture m_scheduledFuture;

	private ThoughtRefreshManager()
	{
		m_thoughtOfTheDayReader = ThoughtOfTheDayReader.getInstance();
		m_execuotorService = Executors.newScheduledThreadPool(
			MINIMUM_THREAD_COUNT);
		register("");
	}

	public static synchronized RefreshManager getInstannce()
	{
		if (m_self == null)
		{
			m_self = new ThoughtRefreshManager();
		}
		return m_self;
	}

	public String getBmpFilePath()
	{
		return null;
	}


	public Object register(String a_itemName)
	{
		// INVOKE THREAD TO READ THOUGHT OF THE DAY CONTENT FROM CONTENT PROVIDER.
		if (!m_isRegistered)
		{
			m_isRegistered = true;
			readThoughtOfTheDayContent();
		}
		return null;
	}

	public Object getResult(String a_itemName)
	{
		return m_thoughtOfTheDayReader.getResult(a_itemName);
	}

	public void unregister(String a_itemName)
	{
		if (m_scheduledFuture != null)
		{
			m_scheduledFuture.cancel(true);
		}
	}

	/**
	 * Shutdowns/Cancels the tasks that are excuting.
	 */
	public void shutdown()
	{
		m_execuotorService.shutdown();
	}

	public boolean isItemExist(String a_itemName)
	{
		return true;
	}

	public void interruptBlockedThreads()
	{

	}

	private void readThoughtOfTheDayContent()
	{
		m_scheduledFuture = m_execuotorService.scheduleWithFixedDelay(new
			RunnableReader(m_thoughtOfTheDayReader, "",  Constants.DEFAULT_THOUGHT_THREAD_TIMEOUT), 0,
			Constants.DEFAULT_THOUGHT_CONTENT_READ_TIMEOUT,
					  TimeUnit.MILLISECONDS);
	}
}
