package com.polycom.sampleapps.servlet.thought;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.RefreshManager;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.exception.ItemNotRegisteredException;

/**
 *
 * <p>Title: ViewThoughtServlet</p>
 *
 * <p>Description: This class displays Thought Of The Day</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author Venu
 * @version 1.0
 */
public class ViewThoughtServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles request from applications.jsp to display thought for the day.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String errorMessage = "";
		String jspPage = "";
		// GETTING USER FROM COOKIE
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user == null)
		{
			errorMessage = "Please login to view Thought For The Day.";
			jspPage = "/login.jsp";
			a_request.setAttribute("errormessage", errorMessage);
		}
		else
		{
			ThoughtForTheDayManager refreshManger = appContext.getThoughtRefreshManager();
			String displayText = (String) refreshManger.getMessage();			
			if (displayText == null)
			{
				errorMessage = "Thought For The Day not available.";
				a_request.setAttribute("errormessage", errorMessage);
			}
			else
			{
				a_request.setAttribute("displaytext", displayText);
			}
			jspPage = "/viewtftd.jsp";
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
