package com.polycom.sampleapps.servlet.user;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.exception.UserAlreadyExistsException;

/**
 *
 * <p>Title: AddUserServlet</p>
 *
 * <p>Description: This servlet will handle the requests from configureuser.jsp through ADMIN configuration page to add the new user to the cache.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class AddUserServlet extends HttpServlet implements SingleThreadModel
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from configureuser.jsp page
	 * Validates the UserName with existing users and then saves it into users.xml file
	 * Also creates user specific xml file with IT manager configured applications.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String message = "";
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			// GETTING USERNAME AND PASSWORD FROM HTTP REQUEST
			String userName = a_request.getParameter("username");
			String password = a_request.getParameter("password");
			String userType = a_request.getParameter("usertype");
			if (userName == null && userName.length() == 0)
			{
				message = "Please enter valid User Name.";
			}
			else if (password == null || password.length() == 0)
			{
				message = "Please enter valid Password.";
			}
			else
			{
				try
				{
					//System.out.println("addig User : " + userName);
					appContext.addUser(userName, password, userType,false);
					message = "'" + userName + "' added successfully.";
				}
				catch (UserAlreadyExistsException ex2)
				{
					message = ex2.getMessage();
				}
				catch (IOException ex2)
				{
					message = "Internal server error.";
				}
			}
			appContext.addUsernameCookieToTheResponse(a_response, user.getUser(), false);
			a_request.setAttribute("contents", appContext.getUsers());
			a_request.setAttribute("user", user);
			a_request.setAttribute("message", message);
			String jspPage = "configureapps.jsp?op=adduser";
			appContext.forward(a_request, a_response, jspPage);
		}
		else
		{
			message = "Please login to add user.";
			String jspPage = "/adminlogin.jsp";
			a_request.setAttribute("errormessage", message);
			appContext.forward(a_request, a_response, jspPage);
		}
	}
}
