package com.polycom.sampleapps.servlet.user;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.polycom.sampleapps.servlet.common.ApplicationContext;
import com.polycom.sampleapps.servlet.common.Constants;
import com.polycom.sampleapps.servlet.common.data.User;
import com.polycom.sampleapps.servlet.common.data.UserProfile;
import com.polycom.sampleapps.servlet.common.persistance.PersistApplications;
import com.polycom.sampleapps.servlet.common.persistance.PersistUser;
import com.polycom.sampleapps.servlet.common.persistance.PersistUsers;

/**
 *
 * <p>Title: ChangePasswordServlet</p>
 *
 * <p>Description: This servlet changes the password for IT Manager/User.</p>
 *
 * <p>Copyright: * Copyright (c) 2006 Polycom Canada Ltd.</p>
 *
 * <p>Company: Polycom, Inc</p>
 *
 * @author NVS Anil
 * @version 1.0
 */
public class ChangePasswordServlet extends HttpServlet
{
	private ServletConfig m_config;
	/**
	 * Initializes the configuration parameters set for this servlet
	 * @param a_config ServletConfig
	 */
	public void init(ServletConfig a_config)
	{
		m_config = a_config;
	}

	/**
	 * Overrided doPost method from HttpServlet.
	 * Handles the POST request from changepswd.jsp page.
	 * Validates the old password and then persist the new password
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doPost(HttpServletRequest a_request,
					   HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String message = "";
		String jspPage = "";
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			// GETTING USERNAME AND PASSWORD FROM HTTP REQUEST
			String oldpassword = a_request.getParameter("oldpassword");
			if (oldpassword.equals(user.getPassword()))
			{
				String newpassword = a_request.getParameter("newpassword");
				user.setPassword(newpassword);
				// PERSIST USER
				// PERSIST USER
				try
				{
					String userFilePath = "";
					if (user.getType().equals(Constants.IT_USER_TYPE))
					{
						userFilePath = appContext.getXmlDirPath() +
							Constants.APPLICATIONS_XML_FILE;
						PersistApplications.persist(user, userFilePath);
					}
					else
					{
						userFilePath = appContext.getXmlDirPath() +
							user.getName() + ".xml";
						PersistUser.persist(user, userFilePath);
						Vector<User> users = appContext.getUsers();
						for (User tempUser : users)
						{
							if (tempUser.getName().equals(user.getName()))
							{
								tempUser.setPassword(newpassword);
								break;
							}
						}
						String usersFilePath = appContext.getXmlDirPath() +
							Constants.USERS_XML_FILE;
						PersistUsers.persist(appContext.getUsers(),
											 usersFilePath);
					}
					message = "Password changed successfully.";
				}
				catch (IOException ex1)
				{
					ApplicationContext.logger.log(Level.SEVERE, ex1.getMessage(),
												  ex1);
				}
			}
			else
			{
				message = "Password does not match.";
			}
			jspPage = "configureapps.jsp?op=changepswd";
			appContext.addUsernameCookieToTheResponse(a_response, user.getUser(), false);
			a_request.setAttribute("user", user);
			a_request.setAttribute("message", message);
		}
		else
		{
			message = "Please login to add user.";
			jspPage = "/adminlogin.jsp";
			a_request.setAttribute("errormessage", message);
		}
		appContext.forward(a_request, a_response, jspPage);
	}

	/**
	 * Overrided doGet method from HttpServlet.
	 * Handles the GET request from changepswd.jsp page and displays change password page.
	 * @param a_request HttpServletRequest
	 * @param a_response HttpServletResponse
	 */
	public void doGet(HttpServletRequest a_request,
					  HttpServletResponse a_response)
	{
		ApplicationContext appContext = ApplicationContext.getInstance(m_config.
			getServletContext());
		String message = "";
		String jspPage = "";
		UserProfile user = appContext.getUserFromCookie(a_request);
		if (user != null)
		{
			appContext.addUsernameCookieToTheResponse(a_response, user.getUser(), false);
			a_request.setAttribute("user", user);
			jspPage = "/configureapps.jsp?op=changepswd";
		}
		else
		{
			message = "Please login to change password.";
			jspPage = "/adminlogin.jsp";
			a_request.setAttribute("errormessage", message);
		}
		appContext.forward(a_request, a_response, jspPage);
	}
}
